/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.core.IStateMapperRegister;
import forestry.arboriculture.genetics.alleles.AlleleFruit;
import forestry.arboriculture.models.FruitPodStateMapper;
import forestry.arboriculture.tiles.TileFruitPod;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFruitPod
extends BlockCocoa
implements IStateMapperRegister,
ITileEntityProvider {
    @Nonnull
    private final IAlleleFruit fruit;

    public static List<BlockFruitPod> create() {
        ArrayList<BlockFruitPod> blocks = new ArrayList<BlockFruitPod>();
        for (IAlleleFruit fruit : AlleleFruit.getFruitAllelesWithModels()) {
            BlockFruitPod block = new BlockFruitPod(fruit);
            blocks.add(block);
        }
        return blocks;
    }

    private BlockFruitPod(@Nonnull IAlleleFruit fruit) {
        this.fruit = fruit;
    }

    @Nonnull
    public IAlleleFruit getFruit() {
        return this.fruit;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileFruitPod tile = TileUtil.getTile((IBlockAccess)world, pos, TileFruitPod.class);
        if (tile == null) {
            return null;
        }
        return tile.getPickBlock();
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.func_176499_e(world, pos, state)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            return;
        }
        TileFruitPod tile = TileUtil.getTile((IBlockAccess)world, pos, TileFruitPod.class);
        if (tile == null) {
            return;
        }
        tile.onBlockTick(world, pos, state, rand);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileFruitPod tile;
        if (!world.field_72995_K && (tile = TileUtil.getTile((IBlockAccess)world, pos, TileFruitPod.class)) != null) {
            for (ItemStack drop : tile.getDrops()) {
                ItemStackUtil.dropItemStackAsEntity(drop, world, pos);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Collections.emptyList();
    }

    public boolean func_176499_e(World world, BlockPos pos, IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        return BlockUtil.isValidPodLocation(world, pos, facing);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        world.func_175713_t(pos);
        super.func_180663_b(world, pos, state);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileFruitPod();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        Proxies.render.registerStateMapper((Block)this, new FruitPodStateMapper());
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        TileFruitPod podTile = TileUtil.getTile((IBlockAccess)world, pos, TileFruitPod.class);
        if (podTile != null) {
            return podTile.canMature();
        }
        return false;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        TileFruitPod podTile = TileUtil.getTile((IBlockAccess)world, pos, TileFruitPod.class);
        if (podTile != null) {
            podTile.addRipeness(0.5f);
        }
    }
}

