/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.greenhouse.IGreenhouseState;
import forestry.api.greenhouse.IInternalBlock;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.greenhouse.multiblock.GreenhouseController;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.World;

public final class GreenhouseState
implements IGreenhouseState {
    private final float humidity;
    private final float temperature;
    private final World world;
    private final List<IInternalBlock> internalBlocks;
    private final Collection<IMultiblockComponent> greenhouseComponents;

    public GreenhouseState(World world, float humidity, float temperature, List<IInternalBlock> internalBlocks, Collection<IMultiblockComponent> greenhouseComponents) {
        this.world = world;
        this.humidity = humidity;
        this.temperature = temperature;
        this.internalBlocks = internalBlocks;
        this.greenhouseComponents = greenhouseComponents;
    }

    public GreenhouseState(GreenhouseController controller) {
        this(controller.getWorldObj(), controller.getExactHumidity(), controller.getExactTemperature(), controller.getInternalBlocks(), controller.getComponents());
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromValue(this.temperature);
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.humidity);
    }

    @Override
    public float getExactTemperature() {
        return this.temperature;
    }

    @Override
    public float getExactHumidity() {
        return this.humidity;
    }

    @Override
    public List<IInternalBlock> getInternalBlocks() {
        return this.internalBlocks;
    }

    @Override
    public Collection<IMultiblockComponent> getGreenhouseComponents() {
        return this.greenhouseComponents;
    }
}

