/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import com.google.common.collect.ImmutableSet;
import forestry.api.farming.FarmDirection;
import forestry.api.multiblock.IFarmComponent;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmHelper {
    public static final ImmutableSet<Block> bricks = ImmutableSet.of((Object)Blocks.field_150336_V, (Object)Blocks.field_150417_aV, (Object)Blocks.field_150322_A, (Object)Blocks.field_150385_bj, (Object)Blocks.field_150371_ca);

    private static FarmDirection getOpposite(FarmDirection farmDirection) {
        EnumFacing forgeDirection = farmDirection.getFacing();
        EnumFacing forgeDirectionOpposite = forgeDirection.func_176734_d();
        return FarmDirection.getFarmDirection(forgeDirectionOpposite);
    }

    public static BlockPos getFarmMultiblockCorner(World world, BlockPos start, FarmDirection farmSide, FarmDirection layoutDirection) {
        BlockPos edge = FarmHelper.getFarmMultiblockEdge(world, start, farmSide);
        return FarmHelper.getFarmMultiblockEdge(world, edge, FarmHelper.getOpposite(layoutDirection));
    }

    private static BlockPos getFarmMultiblockEdge(World world, BlockPos start, FarmDirection direction) {
        BlockPos.MutableBlockPos edge = new BlockPos.MutableBlockPos(start);
        while (world.func_175625_s((BlockPos)edge) instanceof IFarmComponent) {
            edge.func_185337_c(direction.getFacing());
        }
        FarmDirection oppositeDirection = FarmHelper.getOpposite(direction);
        edge.func_185337_c(oppositeDirection.getFacing());
        return edge.func_185334_h();
    }
}

