/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.blocks;

import forestry.core.proxy.Proxies;
import forestry.greenhouse.blocks.BlockGreenhouse;
import forestry.greenhouse.tiles.TileGreenhouseHatch;
import java.util.EnumMap;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum BlockGreenhouseType {
    PLAIN,
    GLASS,
    HATCH_INPUT(true),
    HATCH_OUTPUT(true),
    GEARBOX(true),
    VALVE(true),
    FAN(true, true),
    HEATER(true, true),
    DRYER(true, true),
    CONTROL(true),
    SPRINKLER(false, true),
    DOOR,
    BUTTERFLY_HATCH(true);

    public static final BlockGreenhouseType[] VALUES;
    public final boolean hasOverlaySprite;
    public final boolean activatable;
    @SideOnly(value=Side.CLIENT)
    private static EnumMap<BlockGreenhouseSprites, TextureAtlasSprite> sprites;

    private BlockGreenhouseType(boolean hasOverlaySprite, boolean activatable) {
        this.hasOverlaySprite = hasOverlaySprite;
        this.activatable = activatable;
    }

    private BlockGreenhouseType(boolean hasOverlaySprite) {
        this.hasOverlaySprite = hasOverlaySprite;
        this.activatable = false;
    }

    private BlockGreenhouseType() {
        this.hasOverlaySprite = false;
        this.activatable = false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerSprites() {
        sprites = new EnumMap(BlockGreenhouseSprites.class);
        TextureMap map = Proxies.common.getClientInstance().func_147117_R();
        for (BlockGreenhouseSprites sprite : BlockGreenhouseSprites.VALUES) {
            if (sprite == BlockGreenhouseSprites.PLAIN) {
                sprites.put(sprite, map.func_110572_b("minecraft:blocks/brick"));
                continue;
            }
            if (sprite == BlockGreenhouseSprites.GLASS) {
                sprites.put(sprite, map.func_110572_b("minecraft:blocks/glass_green"));
                continue;
            }
            ResourceLocation location = new ResourceLocation("forestry", "blocks/greenhouse/" + sprite.spriteName);
            TextureAtlasSprite textureAtlasSprite = map.func_174942_a(location);
            sprites.put(sprite, textureAtlasSprite);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getSprite(BlockGreenhouseType type, EnumFacing facing, @Nullable IBlockState state, @Nullable IBlockAccess world, @Nullable BlockPos pos) {
        TileEntity tile = null;
        if (world != null && pos != null) {
            tile = world.func_175625_s(pos);
        }
        switch (type) {
            case PLAIN: {
                return sprites.get((Object)BlockGreenhouseSprites.PLAIN);
            }
            case GLASS: {
                return sprites.get((Object)BlockGreenhouseSprites.GLASS);
            }
            case GEARBOX: {
                return sprites.get((Object)BlockGreenhouseSprites.GEARS);
            }
            case VALVE: {
                return sprites.get((Object)BlockGreenhouseSprites.VALVE);
            }
            case FAN: {
                if (state == null || state.func_177229_b(BlockGreenhouse.STATE) == BlockGreenhouse.State.OFF) {
                    return sprites.get((Object)BlockGreenhouseSprites.FAN_OFF);
                }
                return sprites.get((Object)BlockGreenhouseSprites.FAN_ON);
            }
            case HEATER: {
                if (state == null || state.func_177229_b(BlockGreenhouse.STATE) == BlockGreenhouse.State.OFF) {
                    return sprites.get((Object)BlockGreenhouseSprites.HEATER_OFF);
                }
                return sprites.get((Object)BlockGreenhouseSprites.HEATER_ON);
            }
            case DRYER: {
                return sprites.get((Object)BlockGreenhouseSprites.DRYER);
            }
            case CONTROL: {
                return sprites.get((Object)BlockGreenhouseSprites.CONTROL);
            }
            case HATCH_OUTPUT: 
            case HATCH_INPUT: {
                if (tile == null || facing == null || !(tile instanceof TileGreenhouseHatch)) {
                    return sprites.get((Object)BlockGreenhouseSprites.HATCH_DEFAULT);
                }
                TileGreenhouseHatch hatch = (TileGreenhouseHatch)tile;
                if (hatch.getOutwardsDir() == null) {
                    return sprites.get((Object)BlockGreenhouseSprites.HATCH_DEFAULT);
                }
                if (hatch.getOutwardsDir() == facing) {
                    return sprites.get((Object)BlockGreenhouseSprites.HATCH_OUTPUT);
                }
                if (hatch.getOutwardsDir().func_176734_d() == facing) {
                    return sprites.get((Object)BlockGreenhouseSprites.HATCH_INPUT);
                }
                return null;
            }
            case BUTTERFLY_HATCH: {
                if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
                    return null;
                }
                return sprites.get((Object)BlockGreenhouseSprites.BUTTERFLY_HATCH);
            }
        }
        return Minecraft.func_71410_x().func_147117_R().func_174944_f();
    }

    public static EnumMap<BlockGreenhouseSprites, TextureAtlasSprite> getSprites() {
        return sprites;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    static {
        VALUES = BlockGreenhouseType.values();
    }

    private static enum BlockGreenhouseSprites {
        PLAIN,
        GLASS,
        GEARS("gears"),
        VALVE("valve"),
        FAN_OFF("fan.off"),
        FAN_ON("fan.on"),
        HEATER_OFF("heater.off"),
        HEATER_ON("heater.on"),
        DRYER("dryer"),
        CONTROL("control"),
        HATCH_DEFAULT("hatch"),
        HATCH_INPUT("hatch_input"),
        HATCH_OUTPUT("hatch_output"),
        BUTTERFLY_HATCH("butterfly_hatch");

        public static final BlockGreenhouseSprites[] VALUES;
        private final String spriteName;

        private BlockGreenhouseSprites(String spriteName) {
            this.spriteName = spriteName;
        }

        private BlockGreenhouseSprites() {
            this.spriteName = null;
        }

        static {
            VALUES = BlockGreenhouseSprites.values();
        }
    }
}

