/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.api.core.ForestryAPI;
import forestry.api.core.ISpriteProvider;
import forestry.api.core.ISpriteRegister;
import forestry.api.core.ITextureManager;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextureManager
implements ITextureManager {
    private static final TextureManager instance = new TextureManager();
    private static final Map<String, TextureAtlasSprite> defaultIcons = new HashMap<String, TextureAtlasSprite>();
    private static final DefaultSpriteProvider defaultIconProvider = new DefaultSpriteProvider();
    private static final List<ISpriteProvider> iconProviders = new ArrayList<ISpriteProvider>();
    private final List<ISpriteRegister> spriteRegisters = new ArrayList<ISpriteRegister>();

    public static TextureManager getInstance() {
        return instance;
    }

    private TextureManager() {
    }

    public static void initDefaultSprites() {
        String[] defaultIconNames;
        for (String str : defaultIconNames = new String[]{"habitats/desert", "habitats/end", "habitats/forest", "habitats/hills", "habitats/jungle", "habitats/mushroom", "habitats/nether", "habitats/ocean", "habitats/plains", "habitats/snow", "habitats/swamp", "habitats/taiga", "misc/access.private", "misc/access.viewable", "misc/access.shared", "misc/energy", "misc/hint", "analyzer/anything", "analyzer/bee", "analyzer/cave", "analyzer/closed", "analyzer/drone", "analyzer/flyer", "analyzer/item", "analyzer/nocturnal", "analyzer/princess", "analyzer/pure_breed", "analyzer/pure_cave", "analyzer/pure_flyer", "analyzer/pure_nocturnal", "analyzer/queen", "errors/errored", "errors/unknown", "slots/blocked", "slots/blocked_2", "slots/liquid", "slots/container", "slots/locked", "mail/carrier.player", "mail/carrier.trader"}) {
            TextureAtlasSprite icon = TextureManager.registerSprite("gui/" + str);
            defaultIcons.put(str, icon);
        }
    }

    public static TextureAtlasSprite registerSprite(String identifier) {
        TextureMap map = Proxies.common.getClientInstance().func_147117_R();
        return map.func_174942_a(new ResourceLocation("forestry:" + identifier));
    }

    public static TextureAtlasSprite registerSprite(TextureAtlasSprite sprite, String identifier) {
        TextureMap map = Proxies.common.getClientInstance().func_147117_R();
        if (map.setTextureEntry(identifier, sprite)) {
            return sprite;
        }
        return map.getTextureExtry(identifier);
    }

    public static TextureAtlasSprite getSprite(String modID, String identifier) {
        TextureMap map = Proxies.common.getClientInstance().func_147117_R();
        if (map.func_110572_b(new ResourceLocation(modID + ":" + identifier).toString()) == map.func_174944_f()) {
            return map.func_174942_a(new ResourceLocation(modID + ":" + identifier));
        }
        return map.func_110572_b(new ResourceLocation(modID + ":" + identifier).toString());
    }

    public static TextureAtlasSprite getSprite(String modID, String modifier, String identifier) {
        TextureMap map = Proxies.common.getClientInstance().func_147117_R();
        if (map.func_110572_b(new ResourceLocation(modID + ":" + modifier + "/" + identifier).toString()) == map.func_174944_f()) {
            return map.func_174942_a(new ResourceLocation(modID + ":" + modifier + "/" + identifier));
        }
        return map.func_110572_b(new ResourceLocation(modID + ":" + modifier + "/" + identifier).toString());
    }

    public static TextureAtlasSprite registerSpriteUID(short uid, String identifier) {
        TextureAtlasSprite texture = TextureManager.registerSprite(identifier);
        defaultIconProvider.addTexture(uid, texture);
        return texture;
    }

    @Override
    public TextureAtlasSprite getDefault(String ident) {
        return defaultIcons.get(ident);
    }

    @Override
    public void registerIconProvider(ISpriteProvider provider) {
        iconProviders.add(provider);
    }

    @Override
    public TextureAtlasSprite getSprite(short texUID) {
        if (texUID < 0) {
            return null;
        }
        for (ISpriteProvider provider : iconProviders) {
            TextureAtlasSprite icon = provider.getSprite(texUID);
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    public void registerBlock(Block block) {
        if (block instanceof ISpriteRegister) {
            this.spriteRegisters.add((ISpriteRegister)block);
        }
    }

    public void registerItem(Item item) {
        if (item instanceof ISpriteRegister) {
            this.spriteRegisters.add((ISpriteRegister)item);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSprites() {
        for (ISpriteRegister spriteRegister : this.spriteRegisters) {
            spriteRegister.registerSprites(TextureManager.getInstance());
        }
    }

    static {
        ForestryAPI.textureManager = instance;
        instance.registerIconProvider(defaultIconProvider);
    }

    private static class DefaultSpriteProvider
    implements ISpriteProvider {
        private final Map<Short, TextureAtlasSprite> textures = new HashMap<Short, TextureAtlasSprite>();

        private DefaultSpriteProvider() {
        }

        public void addTexture(short texUID, TextureAtlasSprite texture) {
            this.textures.put(texUID, texture);
        }

        @Override
        public TextureAtlasSprite getSprite(short texUID) {
            return this.textures.get(texUID);
        }

        @Override
        public void registerSprites() {
        }
    }
}

