/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.EnumLeafType;
import forestry.core.proxy.Proxies;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

public class TextureLeaves {
    private static final Map<EnumLeafType, TextureLeaves> leafTextures = new EnumMap<EnumLeafType, TextureLeaves>(EnumLeafType.class);
    private final EnumLeafType leafType;
    private TextureAtlasSprite plain;
    private TextureAtlasSprite fancy;
    private TextureAtlasSprite pollinatedPlain;
    private TextureAtlasSprite pollinatedFancy;

    public static TextureLeaves get(EnumLeafType leafType) {
        return leafTextures.get((Object)leafType);
    }

    public static void registerAllSprites() {
        for (TextureLeaves leafTexture : leafTextures.values()) {
            leafTexture.registerSprites();
        }
    }

    private TextureLeaves(EnumLeafType enumLeafType) {
        this.leafType = enumLeafType;
    }

    private void registerSprites() {
        String ident = this.leafType.toString().toLowerCase(Locale.ENGLISH);
        TextureMap textureMapBlocks = Proxies.common.getClientInstance().func_147117_R();
        this.plain = textureMapBlocks.func_174942_a(new ResourceLocation("forestry", "blocks/leaves/" + ident + ".plain"));
        this.fancy = textureMapBlocks.func_174942_a(new ResourceLocation("forestry", "blocks/leaves/" + ident + ".fancy"));
        this.pollinatedPlain = textureMapBlocks.func_174942_a(new ResourceLocation("forestry", "blocks/leaves/" + ident + ".changed.plain"));
        this.pollinatedFancy = textureMapBlocks.func_174942_a(new ResourceLocation("forestry", "blocks/leaves/" + ident + ".changed"));
    }

    @Nonnull
    public TextureAtlasSprite getSprite(boolean pollinated, boolean fancy) {
        if (pollinated) {
            if (fancy) {
                return this.pollinatedFancy;
            }
            return this.pollinatedPlain;
        }
        if (fancy) {
            return this.fancy;
        }
        return this.plain;
    }

    static {
        for (EnumLeafType leafType : EnumLeafType.values()) {
            leafTextures.put(leafType, new TextureLeaves(leafType));
        }
    }
}

