/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.ledgers;

import com.mojang.authlib.GameProfile;
import forestry.core.access.EnumAccess;
import forestry.core.access.IAccessHandler;
import forestry.core.access.IAccessOwnerListener;
import forestry.core.access.IRestrictedAccess;
import forestry.core.gui.ledgers.Ledger;
import forestry.core.gui.ledgers.LedgerManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import forestry.core.utils.PlayerUtil;
import forestry.core.utils.Translator;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;

public class OwnerLedger
extends Ledger
implements IAccessOwnerListener {
    private final IAccessHandler accessHandler;

    public OwnerLedger(LedgerManager manager, IRestrictedAccess tile) {
        super(manager, "owner");
        this.accessHandler = tile.getAccessHandler();
        this.accessHandler.addOwnerListener(this);
        this.onOwnerSet(this.accessHandler.getOwner());
    }

    private boolean isAccessButton(int mouseX, int mouseY) {
        int shiftX = this.currentShiftX;
        int shiftY = this.currentShiftY + 44;
        return mouseX >= shiftX && (float)mouseX <= (float)this.currentShiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + 12;
    }

    @Override
    public boolean isVisible() {
        return this.accessHandler.isOwned();
    }

    @Override
    public void draw(int x, int y) {
        this.drawBackground(x, y);
        EnumAccess accessType = this.accessHandler.getAccess();
        TextureAtlasSprite accessIcon = TextureManager.getInstance().getDefault("misc/access." + accessType.toString().toLowerCase(Locale.ENGLISH));
        this.drawSprite(accessIcon, x + 3, y + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.drawHeader(Translator.translateToLocal("for.gui.owner"), x + 22, y + 8);
        this.drawText(PlayerUtil.getOwnerName(this.accessHandler), x + 22, y + 20);
        Minecraft minecraft = Proxies.common.getClientInstance();
        boolean playerIsOwner = this.accessHandler.isOwner((EntityPlayer)minecraft.field_71439_g);
        if (playerIsOwner) {
            this.drawSubheader(Translator.translateToLocal("for.gui.access") + ':', x + 22, y + 32);
            this.drawSprite(accessIcon, x + 20, y + 40);
            this.drawText(Translator.translateToLocal(accessType.getUnlocalizedName()), x + 38, y + 44);
        }
    }

    @Override
    public String getTooltip() {
        return Translator.translateToLocal("for.gui.owner") + ": " + PlayerUtil.getOwnerName(this.accessHandler);
    }

    @Override
    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (this.isAccessButton(x, y)) {
            Minecraft minecraft = Proxies.common.getClientInstance();
            EntityPlayerSP player = minecraft.field_71439_g;
            return this.accessHandler.switchAccess((EntityPlayer)player);
        }
        return false;
    }

    @Override
    public void onOwnerSet(GameProfile gameProfile) {
        Minecraft minecraft = Proxies.common.getClientInstance();
        boolean playerIsOwner = PlayerUtil.isSameGameProfile(minecraft.field_71439_g.func_146103_bH(), gameProfile);
        this.maxHeight = playerIsOwner ? 60 : 36;
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        this.accessHandler.removeOwnerListener(this);
    }
}

