/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.EnumWoodType;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodHelper;
import forestry.arboriculture.blocks.WoodTypeStateMapper;
import forestry.core.proxy.Proxies;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockArbStairs
extends BlockStairs
implements IWoodTyped,
IItemModelRegister,
IStateMapperRegister {
    private final boolean fireproof;
    private final EnumWoodType woodType;

    public BlockArbStairs(boolean fireproof, IBlockState modelState, EnumWoodType woodType) {
        super(modelState);
        this.fireproof = fireproof;
        this.woodType = woodType;
        this.func_149647_a(Tabs.tabArboriculture);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerVariant(item, WoodHelper.getResourceLocations(this));
        manager.registerItemModel(item, new WoodHelper.WoodMeshDefinition(this));
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    @Override
    @Nonnull
    public String getBlockKind() {
        return "stairs";
    }

    @Override
    @Nonnull
    public EnumWoodType getWoodType(int meta) {
        return this.woodType;
    }

    @Override
    @Nonnull
    public Collection<EnumWoodType> getWoodTypes() {
        return Collections.singleton(this.woodType);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        Proxies.render.registerStateMapper((Block)this, (IStateMapper)new WoodTypeStateMapper(this, null));
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        int meta = this.func_176201_c(blockState);
        EnumWoodType woodType = this.getWoodType(meta);
        return woodType.getHardness();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        return 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        return 5;
    }
}

