/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.worldgen;

import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.utils.BlockUtil;
import forestry.lepidopterology.PluginLepidopterology;
import forestry.lepidopterology.blocks.BlockSolidCocoon;
import forestry.lepidopterology.tiles.TileCocoon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public abstract class CocoonDecorator {
    private static final PopulateChunkEvent.Populate.EventType EVENT_TYPE = (PopulateChunkEvent.Populate.EventType)EnumHelper.addEnum(PopulateChunkEvent.Populate.EventType.class, (String)"FORESTRY_COCOONS", (Class[])new Class[0], (Object[])new Object[0]);

    public static void decorateCocoons(IChunkGenerator chunkProvider, World world, Random rand, int chunkX, int chunkZ, boolean hasVillageGenerated) {
        if (!TerrainGen.populate((IChunkGenerator)chunkProvider, (World)world, (Random)rand, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)EVENT_TYPE)) {
            return;
        }
        CocoonDecorator.decorateCocoons(world, rand, chunkX, chunkZ);
    }

    public static void decorateCocoons(World world, Random rand, int chunkX, int chunkZ) {
        ArrayList<IButterfly> butterflys = ButterflyManager.butterflyRoot.getIndividualTemplates();
        Collections.shuffle(butterflys, rand);
        for (IButterfly butterfly : butterflys) {
            if (!CocoonDecorator.genCocoon(world, rand, chunkX, chunkZ, butterfly)) continue;
            return;
        }
    }

    public static boolean genCocoon(World world, Random rand, int chunkX, int chunkZ, IButterfly butterfly) {
        if (butterfly.getGenome().getPrimary().getRarity() * PluginLepidopterology.getGenerateCocoonsAmount() < rand.nextFloat() * 100.0f) {
            return false;
        }
        int worldX = chunkX * 16;
        int worldZ = chunkZ * 16;
        BiomeGenBase biome = world.func_180494_b(new BlockPos(worldX, 0, worldZ));
        BiomeDictionary.Type[] types = BiomeDictionary.getTypesForBiome((BiomeGenBase)biome);
        EnumSet<BiomeDictionary.Type> speciesTypes = butterfly.getGenome().getPrimary().getSpawnBiomes();
        boolean biomeTypesGood = false;
        for (BiomeDictionary.Type type : types) {
            if (speciesTypes != null && speciesTypes.size() > 0 && !speciesTypes.contains(type)) continue;
            biomeTypesGood = true;
        }
        if (!biomeTypesGood) {
            return false;
        }
        for (int tries = 0; tries < 4; ++tries) {
            int z;
            int x = worldX + rand.nextInt(16);
            if (!CocoonDecorator.tryGenCocoon(world, x, z = worldZ + rand.nextInt(16), butterfly)) continue;
            return true;
        }
        return false;
    }

    private static boolean tryGenCocoon(World world, int x, int z, IButterfly butterfly) {
        int y = CocoonDecorator.getYForCocoon(world, x, z);
        if (y < 0) {
            return false;
        }
        if (!CocoonDecorator.isValidLocation(world, new BlockPos(x, y, z))) {
            return false;
        }
        return CocoonDecorator.setCocoon(world, new BlockPos(x, y, z), butterfly);
    }

    private static boolean setCocoon(World world, BlockPos pos, IButterfly butterfly) {
        BlockSolidCocoon cocoonBlock = PluginLepidopterology.blocks.solidCocoon;
        boolean placed = world.func_180501_a(pos, cocoonBlock.func_176223_P(), 2);
        if (!placed) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!Block.func_149680_a((Block)cocoonBlock, (Block)state.func_177230_c())) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileCocoon)) {
            return false;
        }
        TileCocoon cocoon = (TileCocoon)tile;
        cocoon.setCaterpillar(butterfly);
        cocoonBlock.func_176213_c(world, pos, state);
        world.func_175704_b(pos, pos);
        return true;
    }

    private static int getYForCocoon(World world, int x, int z) {
        int y = world.func_175645_m(new BlockPos(x, 0, z)).func_177956_o() - 1;
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState blockState = world.func_180495_p(pos);
        if (!blockState.func_177230_c().isLeaves(blockState, (IBlockAccess)world, pos)) {
            return -1;
        }
        do {
            pos.func_177977_b();
        } while ((blockState = world.func_180495_p(pos)).func_177230_c().isLeaves(blockState, (IBlockAccess)world, pos));
        return y;
    }

    public static boolean isValidLocation(World world, BlockPos pos) {
        BlockPos posAbove = pos.func_177984_a();
        IBlockState blockStateAbove = world.func_180495_p(posAbove);
        Block blockAbove = blockStateAbove.func_177230_c();
        if (!blockAbove.isLeaves(blockStateAbove, (IBlockAccess)world, posAbove)) {
            return false;
        }
        BlockPos posBelow = pos.func_177977_b();
        IBlockState blockStateBelow = world.func_180495_p(posBelow);
        return BlockUtil.canReplace(blockStateBelow, world, posBelow);
    }
}

