/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.IWoodAccess;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.BlockArbDoor;
import forestry.arboriculture.blocks.BlockArbFence;
import forestry.arboriculture.blocks.BlockArbFenceGate;
import forestry.arboriculture.blocks.BlockArbLog;
import forestry.arboriculture.blocks.BlockArbPlanks;
import forestry.arboriculture.blocks.BlockArbSlab;
import forestry.arboriculture.blocks.BlockArbStairs;
import forestry.arboriculture.blocks.property.PropertyWoodType;
import forestry.core.utils.Log;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public class WoodAccess
implements IWoodAccess {
    private static final WoodMap logs = new WoodMap("logs");
    private static final WoodMap planks = new WoodMap("planks");
    private static final WoodMap slabs = new WoodMap("slabs");
    private static final WoodMap fences = new WoodMap("fences");
    private static final WoodMap fenceGates = new WoodMap("fenceGates");
    private static final WoodMap stairs = new WoodMap("stairs");
    private static final WoodMap doors = new WoodMap("doors"){

        @Override
        @Nonnull
        public EnumMap<EnumWoodType, ItemStack> getItem(boolean fireproof) {
            return super.getItem(false);
        }

        @Override
        @Nonnull
        public EnumMap<EnumWoodType, IBlockState> getBlock(boolean fireproof) {
            return super.getBlock(false);
        }
    };

    public static void registerLogs(List<BlockArbLog> blocks) {
        for (BlockArbLog block : blocks) {
            WoodAccess.registerWithVariants(block, logs, block.getVariant());
        }
    }

    public static void registerPlanks(List<BlockArbPlanks> blocks) {
        for (BlockArbPlanks block : blocks) {
            WoodAccess.registerWithVariants(block, planks, block.getVariant());
        }
    }

    public static void registerSlabs(List<BlockArbSlab> blocks) {
        for (BlockArbSlab block : blocks) {
            WoodAccess.registerWithVariants(block, slabs, block.getVariant());
        }
    }

    public static void registerFences(List<BlockArbFence> blocks) {
        for (BlockArbFence block : blocks) {
            WoodAccess.registerWithVariants(block, fences, block.getVariant());
        }
    }

    public static void registerFenceGates(List<BlockArbFenceGate> blocks) {
        for (BlockArbFenceGate block : blocks) {
            WoodAccess.registerWithoutVariants(block, fenceGates);
        }
    }

    public static void registerStairs(List<BlockArbStairs> blocks) {
        for (BlockArbStairs block : blocks) {
            WoodAccess.registerWithoutVariants(block, stairs);
        }
    }

    public static void registerDoors(List<BlockArbDoor> blocks) {
        for (BlockArbDoor block : blocks) {
            WoodAccess.registerWithoutVariants(block, doors);
        }
    }

    private static <T extends Block> void registerWithVariants(T woodTyped, WoodMap woodMap, PropertyWoodType property) {
        boolean fireproof = ((IWoodTyped)woodTyped).isFireproof();
        EnumMap<EnumWoodType, ItemStack> itemRegistryMap = woodMap.getItem(fireproof);
        EnumMap<EnumWoodType, IBlockState> blockRegistryMap = woodMap.getBlock(fireproof);
        for (EnumWoodType value : property.func_177700_c()) {
            IBlockState blockState = woodTyped.func_176223_P().func_177226_a((IProperty)property, (Comparable)((Object)value));
            int meta = woodTyped.func_176201_c(blockState);
            EnumWoodType woodType = ((IWoodTyped)woodTyped).getWoodType(meta);
            ItemStack itemStack = new ItemStack(woodTyped, 1, meta);
            itemRegistryMap.put(woodType, itemStack);
            blockRegistryMap.put(woodType, blockState);
        }
    }

    private static <T extends Block, P extends Comparable<P>, V extends P> void registerWithoutVariants(T woodTyped, WoodMap woodMap) {
        boolean fireproof = ((IWoodTyped)woodTyped).isFireproof();
        EnumMap<EnumWoodType, ItemStack> itemRegistryMap = woodMap.getItem(fireproof);
        EnumMap<EnumWoodType, IBlockState> blockRegistryMap = woodMap.getBlock(fireproof);
        IBlockState blockState = woodTyped.func_176223_P();
        EnumWoodType woodType = ((IWoodTyped)woodTyped).getWoodType(0);
        ItemStack itemStack = new ItemStack(woodTyped);
        itemRegistryMap.put(woodType, itemStack);
        blockRegistryMap.put(woodType, blockState);
    }

    @Override
    public ItemStack getPlanks(EnumWoodType woodType, boolean fireproof) {
        return WoodAccess.getItem(woodType, fireproof, planks);
    }

    @Override
    public ItemStack getLog(EnumWoodType woodType, boolean fireproof) {
        return WoodAccess.getItem(woodType, fireproof, logs);
    }

    @Override
    public ItemStack getSlab(EnumWoodType woodType, boolean fireproof) {
        return WoodAccess.getItem(woodType, fireproof, slabs);
    }

    @Override
    public ItemStack getFence(EnumWoodType woodType, boolean fireproof) {
        return WoodAccess.getItem(woodType, fireproof, fences);
    }

    @Override
    public ItemStack getFenceGate(EnumWoodType woodType, boolean fireproof) {
        return WoodAccess.getItem(woodType, fireproof, fenceGates);
    }

    @Override
    public ItemStack getStairs(EnumWoodType woodType, boolean fireproof) {
        return WoodAccess.getItem(woodType, fireproof, stairs);
    }

    @Override
    public ItemStack getDoor(EnumWoodType woodType) {
        return WoodAccess.getItem(woodType, false, doors);
    }

    @Override
    public IBlockState getLogBlock(EnumWoodType woodType, boolean fireproof) {
        return WoodAccess.getBlock(woodType, fireproof, logs);
    }

    @Override
    public IBlockState getPlanksBlock(EnumWoodType woodType, boolean fireproof) {
        return WoodAccess.getBlock(woodType, fireproof, planks);
    }

    @Override
    public IBlockState getSlabBlock(EnumWoodType woodType, boolean fireproof) {
        return WoodAccess.getBlock(woodType, fireproof, slabs);
    }

    @Override
    public IBlockState getFenceBlock(EnumWoodType woodType, boolean fireproof) {
        return WoodAccess.getBlock(woodType, fireproof, fences);
    }

    @Override
    public IBlockState getFenceGateBlock(EnumWoodType woodType, boolean fireproof) {
        return WoodAccess.getBlock(woodType, fireproof, fenceGates);
    }

    @Override
    public IBlockState getStairsBlock(EnumWoodType woodType, boolean fireproof) {
        return WoodAccess.getBlock(woodType, fireproof, stairs);
    }

    @Override
    public IBlockState getDoorBlock(EnumWoodType woodType) {
        return WoodAccess.getBlock(woodType, false, doors);
    }

    private static ItemStack getItem(EnumWoodType woodType, boolean fireproof, WoodMap woodMap) {
        ItemStack itemStack = woodMap.getItem(fireproof).get((Object)woodType);
        if (itemStack == null) {
            Log.error("No stack found for {} {} {}", new Object[]{woodType, woodMap.getName(), fireproof ? "fireproof" : "non-fireproof"});
            return null;
        }
        return itemStack.func_77946_l();
    }

    private static IBlockState getBlock(EnumWoodType woodType, boolean fireproof, WoodMap woodMap) {
        IBlockState blockState = woodMap.getBlock(fireproof).get((Object)woodType);
        if (blockState == null) {
            Log.error("No block found for {} {} {}", new Object[]{woodType, woodMap.getName(), fireproof ? "fireproof" : "non-fireproof"});
            return null;
        }
        return blockState;
    }

    private static class WoodMap {
        @Nonnull
        private final EnumMap<EnumWoodType, ItemStack> normalItems = new EnumMap(EnumWoodType.class);
        @Nonnull
        private final EnumMap<EnumWoodType, ItemStack> fireproofItems = new EnumMap(EnumWoodType.class);
        @Nonnull
        private final EnumMap<EnumWoodType, IBlockState> normalBlocks = new EnumMap(EnumWoodType.class);
        @Nonnull
        private final EnumMap<EnumWoodType, IBlockState> fireproofBlocks = new EnumMap(EnumWoodType.class);
        @Nonnull
        private final String name;

        public WoodMap(@Nonnull String name) {
            this.name = name;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public EnumMap<EnumWoodType, ItemStack> getItem(boolean fireproof) {
            return fireproof ? this.fireproofItems : this.normalItems;
        }

        @Nonnull
        public EnumMap<EnumWoodType, IBlockState> getBlock(boolean fireproof) {
            return fireproof ? this.fireproofBlocks : this.normalBlocks;
        }
    }
}

