/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import com.google.common.collect.ImmutableSet;
import forestry.api.core.IErrorSource;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlyzer;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.errors.EnumErrorCode;
import forestry.core.gui.IHintSource;
import forestry.core.inventory.ItemInventory;
import forestry.core.utils.GeneticsUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ItemInventoryAlyzer
extends ItemInventory
implements IErrorSource,
IHintSource {
    public static final int SLOT_SPECIMEN = 0;
    public static final int SLOT_ANALYZE_1 = 1;
    public static final int SLOT_ANALYZE_2 = 2;
    public static final int SLOT_ANALYZE_3 = 3;
    public static final int SLOT_ANALYZE_4 = 4;
    public static final int SLOT_ANALYZE_5 = 6;
    public static final int SLOT_ENERGY = 5;
    public IAlyzer alyzer;

    public ItemInventoryAlyzer(EntityPlayer player, ItemStack itemstack, IAlyzer alyzer) {
        super(player, 7, itemstack);
        this.alyzer = alyzer;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
        ISpeciesRoot speciesRoot;
        if (!this.hasSpecimen() && slotIndex == 0) {
            ItemStack ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(itemStack);
            speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(ersatz);
        } else {
            speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(this.getSpecimen());
        }
        if (speciesRoot != null) {
            return speciesRoot.getAlyzer().canSlotAccept(this, slotIndex, itemStack);
        }
        return this.alyzer.canSlotAccept(this, slotIndex, itemStack);
    }

    @Override
    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        ItemStack ersatz;
        if (!this.hasSpecimen() && slotIndex == 0 && (ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(itemStack)) != null) {
            super.func_70299_a(slotIndex, ersatz);
            return;
        }
        super.func_70299_a(slotIndex, itemStack);
    }

    @Override
    public void onSlotClick(int slotIndex, EntityPlayer player) {
        ISpeciesRoot speciesRoot;
        if (this.hasSpecimen() && AlleleManager.alleleRegistry.getSpeciesRoot(this.getSpecimen()) == null && slotIndex == 0) {
            ItemStack ersatz = GeneticsUtil.convertSaplingToGeneticEquivalent(this.func_70301_a(slotIndex));
            speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(ersatz);
        } else {
            speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(this.getSpecimen());
        }
        if (speciesRoot != null) {
            speciesRoot.getAlyzer().onSlotClick(this, slotIndex, player);
        } else {
            this.alyzer.onSlotClick(this, slotIndex, player);
        }
    }

    @Override
    public final ImmutableSet<IErrorState> getErrorStates() {
        ImmutableSet.Builder errorStates = ImmutableSet.builder();
        if (!this.hasSpecimen()) {
            errorStates.add((Object)EnumErrorCode.NO_SPECIMEN);
        } else {
            ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(this.getSpecimen());
            if (speciesRoot != null && !speciesRoot.getAlyzer().isAlyzingFuel(this.func_70301_a(5))) {
                errorStates.add((Object)EnumErrorCode.NO_HONEY);
            }
        }
        return errorStates.build();
    }

    public ItemStack getSpecimen() {
        for (int i = 0; i <= 6; ++i) {
            ItemStack itemStack;
            if (i == 5 || (itemStack = this.func_70301_a(i)) == null) continue;
            return itemStack;
        }
        return null;
    }

    public boolean hasSpecimen() {
        return this.getSpecimen() != null;
    }

    @Override
    public List<String> getHints() {
        ISpeciesRoot speciesRoot;
        IAlyzer alyzer;
        if (this.hasSpecimen() && (alyzer = (speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(this.getSpecimen())).getAlyzer()) instanceof IHintSource) {
            return ((IHintSource)((Object)alyzer)).getHints();
        }
        return Collections.emptyList();
    }
}

