/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlyzer;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IGuiAlyzer;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.items.ItemRegistryApiculture;
import forestry.core.PluginCore;
import forestry.core.inventory.ItemInventoryAlyzer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public abstract class Alyzer<II extends IIndividual, T extends ISpeciesType, G extends IGuiAlyzer>
implements IAlyzer<II, T, G, ItemInventoryAlyzer> {
    protected final Map<String, ItemStack> iconStacks = new HashMap<String, ItemStack>();
    private final ISpeciesRoot speciesRoot;

    public Alyzer(ISpeciesRoot speciesRoot) {
        this.speciesRoot = speciesRoot;
    }

    @Override
    public boolean canSlotAccept(ItemInventoryAlyzer inventory, int slotIndex, ItemStack itemStack) {
        if (slotIndex == 5) {
            if (inventory.hasSpecimen()) {
                ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(inventory.getSpecimen());
                return speciesRoot.getAlyzer().isAlyzingFuel(itemStack);
            }
            return false;
        }
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(itemStack);
        if (speciesRoot == null || !speciesRoot.isMember(itemStack)) {
            return false;
        }
        if (inventory.hasSpecimen() && inventory.func_70301_a(slotIndex) == null) {
            return false;
        }
        if (slotIndex == 0) {
            return true;
        }
        IIndividual individual = speciesRoot.getMember(itemStack);
        return individual.isAnalyzed();
    }

    @Override
    public void onSlotClick(ItemInventoryAlyzer inventory, int slotIndex, EntityPlayer player) {
        ItemStack specimen = inventory.func_70301_a(0);
        if (specimen == null) {
            return;
        }
        ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(specimen);
        if (speciesRoot == null) {
            return;
        }
        IIndividual individual = speciesRoot.getMember(specimen);
        if (!individual.isAnalyzed()) {
            if (ForestryAPI.enabledPlugins.contains("forestry.apiculture") && !speciesRoot.getAlyzer().isAlyzingFuel(inventory.func_70301_a(5))) {
                return;
            }
            individual.analyze();
            if (player != null) {
                IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker(player.field_70170_p, player.func_146103_bH());
                breedingTracker.registerSpecies(individual.getGenome().getPrimary());
                breedingTracker.registerSpecies(individual.getGenome().getSecondary());
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            individual.writeToNBT(nbttagcompound);
            specimen.func_77982_d(nbttagcompound);
            inventory.func_70298_a(5, 1);
        }
        inventory.func_70299_a(1, specimen);
        inventory.func_70299_a(0, null);
        PluginCore.items.portableAlyzer.openGui(player);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return this.speciesRoot;
    }

    @Override
    public Map<String, ItemStack> getIconStacks() {
        return this.iconStacks;
    }

    @Override
    public ResourceLocation getGuiTexture() {
        return new ResourceLocation("forestry", "textures/gui/portablealyzer.png");
    }

    @Override
    public boolean isAlyzingFuel(ItemStack itemstack) {
        if (itemstack == null || itemstack.field_77994_a <= 0) {
            return false;
        }
        ItemRegistryApiculture beeItems = PluginApiculture.items;
        if (beeItems == null) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        return beeItems.honeyDrop == item || beeItems.honeydew == item;
    }
}

