/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse;

import forestry.api.core.EnumCamouflageType;
import forestry.api.greenhouse.IGreenhouseAccess;
import forestry.core.utils.Log;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GreenhouseAccess
implements IGreenhouseAccess {
    private final Map<ItemStack, Float> greenhouseGlasses = new HashMap<ItemStack, Float>();
    private final Map<EnumCamouflageType, List<ItemStack>> camouflageBlockBlacklist = new EnumMap<EnumCamouflageType, List<ItemStack>>(EnumCamouflageType.class);

    public GreenhouseAccess() {
        for (EnumCamouflageType type : EnumCamouflageType.VALUES) {
            this.camouflageBlockBlacklist.put(type, new ArrayList());
        }
    }

    @Override
    public void registerGreenhouseGlass(@Nonnull ItemStack glass, float lightTransmittance) {
        if (glass == null || glass.func_77973_b() == null) {
            Log.error("Fail to register greenhouse glass, because it is null", new Object[0]);
            return;
        }
        Block block = Block.func_149634_a((Item)glass.func_77973_b());
        if (block == null) {
            Log.error("Fail to register greenhouse glass, it has no matching block: " + glass + ".", new Object[0]);
            return;
        }
        IBlockState defaultBlockState = block.func_176223_P();
        if (block.func_149662_c(defaultBlockState)) {
            Log.error("Fail to register greenhouse glass, it is opaque: " + block + ".", new Object[0]);
            return;
        }
        for (ItemStack greenhouseGlass : this.greenhouseGlasses.keySet()) {
            if (greenhouseGlass.func_77973_b() != glass.func_77973_b() || greenhouseGlass.func_77952_i() != glass.func_77952_i() || !ItemStack.func_77970_a((ItemStack)glass, (ItemStack)greenhouseGlass)) continue;
            Log.error("Fail to register greenhouse glass, because it is already registered: " + glass + ".", new Object[0]);
            return;
        }
        this.greenhouseGlasses.put(glass, Float.valueOf(lightTransmittance));
    }

    @Override
    public float getGreenhouseGlassLightTransmittance(@Nonnull ItemStack glass) {
        if (glass == null || glass.func_77973_b() == null || Block.func_149634_a((Item)glass.func_77973_b()) == null) {
            return 0.5f;
        }
        for (Map.Entry<ItemStack, Float> greenhouseGlassEntry : this.greenhouseGlasses.entrySet()) {
            ItemStack greenhouseGlass = greenhouseGlassEntry.getKey();
            if (greenhouseGlass.func_77973_b() != glass.func_77973_b() || greenhouseGlass.func_77952_i() != glass.func_77952_i() || !ItemStack.func_77970_a((ItemStack)glass, (ItemStack)greenhouseGlass)) continue;
            return greenhouseGlassEntry.getValue().floatValue();
        }
        return 0.5f;
    }

    @Override
    public boolean isGreenhouseGlass(@Nonnull ItemStack glass) {
        if (glass == null || glass.func_77973_b() == null || Block.func_149634_a((Item)glass.func_77973_b()) == null) {
            return false;
        }
        for (ItemStack greenhouseGlass : this.greenhouseGlasses.keySet()) {
            if (greenhouseGlass.func_77973_b() != glass.func_77973_b() || greenhouseGlass.func_77952_i() != glass.func_77952_i() || !ItemStack.func_77970_a((ItemStack)glass, (ItemStack)greenhouseGlass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addToCamouflageBlockBlackList(@Nonnull EnumCamouflageType type, @Nonnull ItemStack camouflageBlock) {
        if (camouflageBlock == null || camouflageBlock.func_77973_b() == null) {
            Log.error("Fail to add camouflage block item to the black list, because it is null", new Object[0]);
            return;
        }
        Block block = Block.func_149634_a((Item)camouflageBlock.func_77973_b());
        if (block == null) {
            Log.error("Fail to add camouflage block item to the black list: because it has no block.", new Object[0]);
            return;
        }
        for (ItemStack camouflageBlacklisted : this.camouflageBlockBlacklist.get((Object)type)) {
            if (camouflageBlacklisted.func_77973_b() != camouflageBlock.func_77973_b() || camouflageBlacklisted.func_77952_i() != camouflageBlock.func_77952_i() || !ItemStack.func_77970_a((ItemStack)camouflageBlock, (ItemStack)camouflageBlacklisted)) continue;
            Log.error("Fail to add camouflage block item to the black list, because it is already registered: " + camouflageBlock + ".", new Object[0]);
            return;
        }
        this.camouflageBlockBlacklist.get((Object)type).add(camouflageBlock);
    }

    @Override
    public boolean isOnCamouflageBlockBlackList(@Nonnull EnumCamouflageType type, @Nonnull ItemStack camouflageBlock) {
        if (camouflageBlock == null || camouflageBlock.func_77973_b() == null || Block.func_149634_a((Item)camouflageBlock.func_77973_b()) == null) {
            return false;
        }
        for (ItemStack camouflageBlacklisted : this.camouflageBlockBlacklist.get((Object)type)) {
            if (camouflageBlacklisted.func_77973_b() != camouflageBlock.func_77973_b() || camouflageBlacklisted.func_77952_i() != camouflageBlock.func_77952_i() || !ItemStack.func_77970_a((ItemStack)camouflageBlock, (ItemStack)camouflageBlacklisted)) continue;
            return true;
        }
        return false;
    }
}

