/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividualLiving;
import forestry.core.genetics.Individual;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class IndividualLiving
extends Individual
implements IIndividualLiving {
    private int health;
    private int maxHealth;

    protected IndividualLiving() {
    }

    protected IndividualLiving(int newHealth) {
        this.health = this.maxHealth = newHealth;
    }

    protected IndividualLiving(@Nonnull NBTTagCompound nbt) {
        super(nbt);
        this.health = nbt.func_74762_e("Health");
        this.maxHealth = nbt.func_74762_e("MaxH");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("Health", this.health);
        nbttagcompound.func_74768_a("MaxH", this.maxHealth);
        if (this.getGenome() != null) {
            NBTTagCompound nbtGenome = new NBTTagCompound();
            this.getGenome().writeToNBT(nbtGenome);
            nbttagcompound.func_74782_a("Genome", (NBTBase)nbtGenome);
        }
        if (this.getMate() != null) {
            NBTTagCompound nbtMate = new NBTTagCompound();
            this.getMate().writeToNBT(nbtMate);
            nbttagcompound.func_74782_a("Mate", (NBTBase)nbtMate);
        }
    }

    @Override
    public abstract IGenome getMate();

    @Override
    public boolean isAlive() {
        return this.health > 0;
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public final void setHealth(int health) {
        if (health < 0) {
            health = 0;
        } else if (health > this.getMaxHealth()) {
            health = this.getMaxHealth();
        }
        this.health = health;
    }

    @Override
    public int getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public void age(World world, float lifespanModifier) {
        float ageModifier;
        if (lifespanModifier < 0.001f) {
            this.setHealth(0);
            return;
        }
        for (ageModifier = 1.0f / lifespanModifier; ageModifier > 1.0f; ageModifier -= 1.0f) {
            this.decreaseHealth();
        }
        if (world.field_73012_v.nextFloat() < ageModifier) {
            this.decreaseHealth();
        }
    }

    private void decreaseHealth() {
        if (this.health > 0) {
            this.setHealth(this.health - 1);
        }
    }
}

