/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.tiles;

import forestry.api.greenhouse.DefaultGreenhouseListener;
import forestry.api.greenhouse.IGreenhouseHousing;
import forestry.api.greenhouse.IGreenhouseListener;
import forestry.api.multiblock.IGreenhouseComponent;
import forestry.api.multiblock.IGreenhouseController;
import forestry.greenhouse.tiles.TileGreenhouse;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileGreenhouseControl
extends TileGreenhouse
implements IGreenhouseComponent.Listener {
    private final IGreenhouseListener greenhouseListener = new ControlGreenhouseListener(this);

    @Override
    public IGreenhouseListener getGreenhouseListener() {
        return this.greenhouseListener;
    }

    private static class ControlGreenhouseListener
    extends DefaultGreenhouseListener {
        private final TileGreenhouseControl tile;

        public ControlGreenhouseListener(TileGreenhouseControl tile) {
            this.tile = tile;
        }

        @Override
        public <G extends IGreenhouseController & IGreenhouseHousing> boolean canWork(G greenhouse, boolean canWork) {
            return canWork && this.hasRedstoneSignal();
        }

        private boolean hasRedstoneSignal() {
            for (EnumFacing direction : EnumFacing.field_82609_l) {
                BlockPos side = this.tile.func_174877_v().func_177972_a(direction);
                EnumFacing dir = direction.func_176734_d();
                World world = this.tile.func_145831_w();
                if (world.func_175651_c(side, dir) <= 0 && world.func_175627_a(side, dir) <= 0) continue;
                return true;
            }
            return false;
        }
    }
}

