/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.TileBase;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.gui.ContainerWorktable;
import forestry.factory.gui.GuiWorktable;
import forestry.factory.inventory.InventoryCraftingForestry;
import forestry.factory.inventory.InventoryGhostCrafting;
import forestry.factory.inventory.InventoryWorktable;
import forestry.factory.recipes.MemorizedRecipe;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.ICrafterWorktable;
import java.io.IOException;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeHooks;

public class TileWorktable
extends TileBase
implements ICrafterWorktable {
    private RecipeMemory recipeMemory;
    private final InventoryAdapterTile craftingDisplay;
    private MemorizedRecipe currentRecipe;

    public TileWorktable() {
        super("worktable");
        this.setInternalInventory(new InventoryWorktable(this));
        this.craftingDisplay = new InventoryGhostCrafting<TileWorktable>(this, 10);
        this.recipeMemory = new RecipeMemory();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.craftingDisplay.writeToNBT(nbttagcompound);
        this.recipeMemory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.craftingDisplay.readFromNBT(nbttagcompound);
        this.recipeMemory = new RecipeMemory(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.craftingDisplay.writeData(data);
        this.recipeMemory.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.craftingDisplay.readData(data);
        this.recipeMemory.readData(data);
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
        this.recipeMemory.validate(this.field_145850_b);
    }

    public boolean hasRecipeConflict() {
        return this.currentRecipe != null && this.currentRecipe.hasRecipeConflict();
    }

    public void chooseNextConflictRecipe() {
        if (this.currentRecipe != null) {
            this.currentRecipe.incrementRecipe();
        }
    }

    public void choosePreviousConflictRecipe() {
        if (this.currentRecipe != null) {
            this.currentRecipe.decrementRecipe();
        }
    }

    @Override
    public boolean canTakeStack(int craftingSlotIndex) {
        if (craftingSlotIndex == 9) {
            return this.canCraftCurrentRecipe();
        }
        return true;
    }

    private boolean canCraftCurrentRecipe() {
        ItemStack[] inventory;
        if (this.currentRecipe == null) {
            return false;
        }
        ItemStack[] recipeItems = InventoryUtil.getStacks((IInventory)this.currentRecipe.getCraftMatrix());
        InventoryCraftingForestry crafting = RecipeUtil.getCraftRecipe(recipeItems, inventory = InventoryUtil.getStacks((IInventory)this), this.field_145850_b, this.currentRecipe.getRecipeOutput());
        return crafting != null;
    }

    @Override
    public boolean onCraftingStart(EntityPlayer player) {
        ItemStack[] inventory;
        if (this.currentRecipe == null) {
            return false;
        }
        ItemStack[] recipeItems = InventoryUtil.getStacks((IInventory)this.currentRecipe.getCraftMatrix());
        InventoryCraftingForestry crafting = RecipeUtil.getCraftRecipe(recipeItems, inventory = InventoryUtil.getStacks((IInventory)this), this.field_145850_b, this.currentRecipe.getRecipeOutput());
        if (crafting == null) {
            return false;
        }
        recipeItems = InventoryUtil.getStacks((IInventory)crafting);
        ItemStack[] removed = InventoryUtil.removeSets((IInventory)this, 1, recipeItems, player, false, false, false);
        if (removed == null) {
            return false;
        }
        this.setCraftingDisplay((IInventory)crafting);
        return true;
    }

    @Override
    public void onCraftingComplete(EntityPlayer player) {
        IInventory craftingInventory = this.getCraftingDisplay();
        for (int i = 0; i < craftingInventory.func_70302_i_(); ++i) {
            ItemStack itemStack = craftingInventory.func_70301_a(i);
            if (itemStack == null) continue;
            ItemStack container = null;
            if (itemStack.func_77973_b().hasContainerItem(itemStack)) {
                container = ForgeHooks.getContainerItem((ItemStack)itemStack);
            } else if (itemStack.field_77994_a > 1) {
                container = ItemStackUtil.createSplitStack(itemStack, itemStack.field_77994_a - 1);
                itemStack.field_77994_a = 1;
            }
            if (container == null || InventoryUtil.tryAddStack((IInventory)this, container, true)) continue;
            player.func_71019_a(container, false);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.recipeMemory.memorizeRecipe(this.field_145850_b.func_82737_E(), this.currentRecipe);
        }
    }

    @Override
    public ItemStack getResult() {
        if (this.currentRecipe == null) {
            return null;
        }
        ItemStack result = this.currentRecipe.getRecipeOutput();
        if (result != null) {
            result = result.func_77946_l();
        }
        return result;
    }

    public RecipeMemory getMemory() {
        return this.recipeMemory;
    }

    public void chooseRecipeMemory(int recipeIndex) {
        MemorizedRecipe recipe = this.recipeMemory.getRecipe(recipeIndex);
        this.setCurrentRecipe(recipe);
    }

    private void setCraftingDisplay(IInventory craftMatrix) {
        if (craftMatrix == null) {
            return;
        }
        for (int slot = 0; slot < craftMatrix.func_70302_i_(); ++slot) {
            this.craftingDisplay.func_70299_a(slot, craftMatrix.func_70301_a(slot));
        }
    }

    public IInventory getCraftingDisplay() {
        return new InventoryMapper((IInventory)this.craftingDisplay, 0, 9);
    }

    public void clearCraftMatrix() {
        for (int slot = 0; slot < this.craftingDisplay.func_70302_i_(); ++slot) {
            this.craftingDisplay.func_70299_a(slot, null);
        }
    }

    public void setCurrentRecipe(InventoryCraftingForestry crafting) {
        ItemStack[] currentStacks;
        ItemStack[] stacks;
        MemorizedRecipe recipe;
        List<ItemStack> recipeOutputs = RecipeUtil.findMatchingRecipes(crafting, this.field_145850_b);
        MemorizedRecipe memorizedRecipe = recipe = recipeOutputs.isEmpty() ? null : new MemorizedRecipe(crafting, recipeOutputs);
        if (this.currentRecipe != null && recipe != null && recipe.hasRecipeOutput(this.currentRecipe.getRecipeOutput()) && ItemStackUtil.equalSets(stacks = InventoryUtil.getStacks((IInventory)crafting), currentStacks = InventoryUtil.getStacks((IInventory)this.currentRecipe.getCraftMatrix()))) {
            return;
        }
        this.setCurrentRecipe(recipe);
    }

    public MemorizedRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void setCurrentRecipe(MemorizedRecipe recipe) {
        this.currentRecipe = recipe;
        if (this.currentRecipe != null) {
            this.setCraftingDisplay((IInventory)this.currentRecipe.getCraftMatrix());
        }
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiWorktable(player, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerWorktable(player, this);
    }
}

