/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.Fluids;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.fluids.tanks.StandardTank;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.watchers.ISlotPickupWatcher;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.items.ICraftingPlan;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.factory.gui.ContainerFabricator;
import forestry.factory.gui.GuiFabricator;
import forestry.factory.inventory.InventoryFabricator;
import forestry.factory.inventory.InventoryGhostCrafting;
import forestry.factory.recipes.FabricatorRecipeManager;
import forestry.factory.recipes.FabricatorSmeltingRecipeManager;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileFabricator
extends TilePowered
implements ISlotPickupWatcher,
ILiquidTankTile,
IFluidHandler,
ISidedInventory {
    private static final int MAX_HEAT = 5000;
    private final InventoryAdapterTile craftingInventory;
    private final TankManager tankManager;
    private final FilteredTank moltenTank;
    private int heat = 0;
    private int meltingPoint = 0;

    public TileFabricator() {
        super("fabricator", 1100, 3300);
        this.setEnergyPerWorkCycle(200);
        this.craftingInventory = new InventoryGhostCrafting<TileFabricator>(this, 9);
        this.setInternalInventory(new InventoryFabricator(this));
        this.moltenTank = new FilteredTank(8000, Fluids.GLASS.getFluid());
        this.moltenTank.tankMode = StandardTank.TankMode.INTERNAL;
        this.tankManager = new TankManager(this, this.moltenTank);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("Heat", this.heat);
        this.tankManager.writeToNBT(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.heat = nbttagcompound.func_74762_e("Heat");
        this.tankManager.readFromNBT(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (!this.moltenTank.isFull()) {
            this.trySmelting();
        }
        if (!this.moltenTank.isEmpty() && this.heat < this.getMeltingPoint() - 100) {
            this.moltenTank.drain(5, true);
        }
        if (this.heat > 2500) {
            this.heat -= 2;
        } else if (this.heat > 0) {
            --this.heat;
        }
    }

    private void trySmelting() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack smeltResource = inventory.func_70301_a(0);
        if (smeltResource == null) {
            return;
        }
        IFabricatorSmeltingRecipe smelt = FabricatorSmeltingRecipeManager.findMatchingSmelting(smeltResource);
        if (smelt == null || smelt.getMeltingPoint() > this.heat) {
            return;
        }
        FluidStack smeltFluid = smelt.getProduct();
        if (this.moltenTank.canFill(smeltFluid)) {
            this.func_70298_a(0, 1);
            this.moltenTank.fill(smeltFluid, true);
            this.meltingPoint = smelt.getMeltingPoint();
        }
    }

    @Override
    public boolean workCycle() {
        this.heat += 100;
        if (this.heat > 5000) {
            this.heat = 5000;
        }
        this.craftResult();
        return true;
    }

    private IFabricatorRecipe getRecipe() {
        IInventoryAdapter inventory = this.getInternalInventory();
        ItemStack plan = inventory.func_70301_a(1);
        FluidStack liquid = this.moltenTank.getFluid();
        IFabricatorRecipe recipe = FabricatorRecipeManager.findMatchingRecipe(plan, (IInventory)this.craftingInventory);
        if (liquid != null && !liquid.containsFluid(recipe.getLiquid())) {
            return null;
        }
        return recipe;
    }

    public ItemStack getResult() {
        IFabricatorRecipe myRecipe = this.getRecipe();
        if (myRecipe == null) {
            return null;
        }
        return myRecipe.getRecipeOutput().func_77946_l();
    }

    @Override
    public void onPickupFromSlot(int slotIndex, EntityPlayer player) {
        if (slotIndex == 2) {
            this.func_70298_a(2, 1);
        }
    }

    private void craftResult() {
        Item planItem;
        IFabricatorRecipe myRecipe = this.getRecipe();
        if (myRecipe == null) {
            return;
        }
        ItemStack result = this.getResult();
        if (result == null) {
            return;
        }
        if (this.func_70301_a(2) != null) {
            return;
        }
        FluidStack liquid = myRecipe.getLiquid();
        ItemStack[] crafting = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
        if (!this.removeFromInventory(crafting, null, false)) {
            return;
        }
        if (!this.moltenTank.canDrain(liquid)) {
            return;
        }
        this.removeFromInventory(crafting, null, true);
        this.moltenTank.drain(liquid.amount, true);
        if (this.func_70301_a(1) != null && (planItem = this.func_70301_a(1).func_77973_b()) instanceof ICraftingPlan) {
            this.func_70299_a(1, ((ICraftingPlan)planItem).planUsed(this.func_70301_a(1), result));
        }
        this.func_70299_a(2, result);
    }

    private boolean removeFromInventory(ItemStack[] set, EntityPlayer player, boolean doRemove) {
        InventoryMapper inventory = new InventoryMapper((IInventory)this, 3, 18);
        return InventoryUtil.removeSets(inventory, 1, set, player, true, true, false, doRemove);
    }

    @Override
    public boolean hasWork() {
        boolean hasRecipe = true;
        boolean hasLiquidResources = true;
        boolean hasResources = true;
        ItemStack plan = this.func_70301_a(1);
        IFabricatorRecipe recipe = FabricatorRecipeManager.findMatchingRecipe(plan, (IInventory)this.craftingInventory);
        if (recipe != null) {
            ItemStack[] crafting = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
            hasResources = this.removeFromInventory(crafting, null, false);
            hasLiquidResources = this.moltenTank.canDrain(recipe.getLiquid());
        } else {
            hasRecipe = false;
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NO_RECIPE);
        errorLogic.setCondition(!hasLiquidResources, EnumErrorCode.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(!hasResources, EnumErrorCode.NO_RESOURCE_INVENTORY);
        return hasRecipe;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 5000;
    }

    private int getMeltingPoint() {
        if (this.func_70301_a(0) != null) {
            IFabricatorSmeltingRecipe smelt = FabricatorSmeltingRecipeManager.findMatchingSmelting(this.func_70301_a(0));
            if (smelt != null) {
                return smelt.getMeltingPoint();
            }
        } else if (this.moltenTank.getFluidAmount() > 0) {
            return this.meltingPoint;
        }
        return 0;
    }

    public int getMeltingPointScaled(int i) {
        int meltingPoint = this.getMeltingPoint();
        if (meltingPoint <= 0) {
            return 0;
        }
        return meltingPoint * i / 5000;
    }

    public void getGUINetworkData(int i, int j) {
        if (i == 0) {
            this.heat = j;
        } else if (i == 1) {
            this.meltingPoint = j;
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.heat);
        iCrafting.func_71112_a(container, 1, this.getMeltingPoint());
    }

    public InventoryAdapter getCraftingInventory() {
        return this.craftingInventory;
    }

    @Override
    @Nonnull
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(from, resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiFabricator(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerFabricator(player.field_71071_by, this);
    }
}

