/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.models;

import forestry.core.render.TextureManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum EnumFarmBlockTexture {
    BRICK_STONE(new ItemStack(Blocks.field_150417_aV, 1, 0)),
    BRICK_MOSSY(new ItemStack(Blocks.field_150417_aV, 1, 1)),
    BRICK_CRACKED(new ItemStack(Blocks.field_150417_aV, 1, 2)),
    BRICK(new ItemStack(Blocks.field_150336_V)),
    SANDSTONE_SMOOTH(new ItemStack(Blocks.field_150322_A, 1, 2)),
    SANDSTONE_CHISELED(new ItemStack(Blocks.field_150322_A, 1, 1)),
    BRICK_NETHER(new ItemStack(Blocks.field_150385_bj)),
    BRICK_CHISELED(new ItemStack(Blocks.field_150417_aV, 1, 3)),
    QUARTZ(new ItemStack(Blocks.field_150371_ca, 1, 0)),
    QUARTZ_CHISELED(new ItemStack(Blocks.field_150371_ca, 1, 1)),
    QUARTZ_LINES(new ItemStack(Blocks.field_150371_ca, 1, 2));

    private final ItemStack base;

    private EnumFarmBlockTexture(ItemStack base) {
        this.base = base;
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getSprite(EnumFarmBlockTexture texture, int side) {
        switch (texture) {
            case BRICK: {
                return TextureManager.getSprite("minecraft", "blocks/brick");
            }
            case BRICK_STONE: {
                return TextureManager.getSprite("minecraft", "blocks/stonebrick");
            }
            case BRICK_CHISELED: {
                return TextureManager.getSprite("minecraft", "blocks/stonebrick_carved");
            }
            case BRICK_CRACKED: {
                return TextureManager.getSprite("minecraft", "blocks/stonebrick_cracked");
            }
            case BRICK_MOSSY: {
                return TextureManager.getSprite("minecraft", "blocks/stonebrick_mossy");
            }
            case BRICK_NETHER: {
                return TextureManager.getSprite("minecraft", "blocks/nether_brick");
            }
            case SANDSTONE_CHISELED: {
                if (side == 0) {
                    return TextureManager.getSprite("minecraft", "blocks/sandstone_bottom");
                }
                if (side == 1) {
                    return TextureManager.getSprite("minecraft", "blocks/sandstone_top");
                }
                return TextureManager.getSprite("minecraft", "blocks/sandstone_carved");
            }
            case SANDSTONE_SMOOTH: {
                if (side == 0) {
                    return TextureManager.getSprite("minecraft", "blocks/sandstone_bottom");
                }
                if (side == 1) {
                    return TextureManager.getSprite("minecraft", "blocks/sandstone_top");
                }
                return TextureManager.getSprite("minecraft", "blocks/sandstone_smooth");
            }
            case QUARTZ: {
                if (side == 0) {
                    return TextureManager.getSprite("minecraft", "blocks/quartz_block_bottom");
                }
                if (side == 1) {
                    return TextureManager.getSprite("minecraft", "blocks/quartz_block_top");
                }
                return TextureManager.getSprite("minecraft", "blocks/quartz_block_side");
            }
            case QUARTZ_CHISELED: {
                if (side == 0 || side == 1) {
                    return TextureManager.getSprite("minecraft", "blocks/quartz_block_chiseled_top");
                }
                return TextureManager.getSprite("minecraft", "blocks/quartz_block_chiseled");
            }
            case QUARTZ_LINES: {
                if (side == 0 || side == 1) {
                    return TextureManager.getSprite("minecraft", "blocks/quartz_block_lines_top");
                }
                return TextureManager.getSprite("minecraft", "blocks/quartz_block_lines");
            }
        }
        return null;
    }

    public void saveToCompound(NBTTagCompound compound) {
        compound.func_74768_a("FarmBlock", this.ordinal());
    }

    public String getName() {
        return this.base.func_77973_b().func_77653_i(this.base);
    }

    public ItemStack getBase() {
        return this.base;
    }

    public static EnumFarmBlockTexture getFromCompound(NBTTagCompound compound) {
        int farmBlockOrdinal;
        if (compound != null && (farmBlockOrdinal = compound.func_74762_e("FarmBlock")) < EnumFarmBlockTexture.values().length) {
            return EnumFarmBlockTexture.values()[farmBlockOrdinal];
        }
        return BRICK_STONE;
    }
}

