/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.core.fluids.Fluids;
import forestry.core.utils.BlockUtil;
import forestry.farming.FarmHelper;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public abstract class FarmLogicWatered
extends FarmLogic {
    protected final IBlockState ground;
    private final ItemStack resource;
    private static final FluidStack STACK_WATER = Fluids.WATER.getFluid(1000);
    protected List<ItemStack> produce = new ArrayList<ItemStack>();

    protected FarmLogicWatered(ItemStack resource, @Nonnull IBlockState ground) {
        this.ground = ground;
        this.resource = resource;
    }

    @Override
    public int getFertilizerConsumption() {
        return 5;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(20.0f * hydrationModifier);
    }

    protected boolean isAcceptedGround(IBlockState ground) {
        return this.ground.func_177230_c() == ground.func_177230_c();
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return this.resource.func_77969_a(itemstack);
    }

    @Override
    public Collection<ItemStack> collect(World world, IFarmHousing farmHousing) {
        List<ItemStack> products = this.produce;
        this.produce = new ArrayList<ItemStack>();
        return products;
    }

    @Override
    public boolean cultivate(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        if (this.maintainSoil(world, farmHousing, pos, direction, extent)) {
            return true;
        }
        if (!this.isManual && this.maintainWater(world, farmHousing, pos, direction, extent)) {
            return true;
        }
        return this.maintainCrops(world, farmHousing, pos.func_177982_a(0, 1, 0), direction, extent);
    }

    private boolean maintainSoil(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        ItemStack[] resources = new ItemStack[]{this.resource};
        for (int i = 0; i < extent; ++i) {
            BlockPos position = this.translateWithOffset(pos, direction, i);
            IBlockState state = world.func_180495_p(position);
            if (this.isAcceptedGround(state) || this.isWaterSourceBlock(world, position) || !farmHousing.getFarmInventory().hasResources(resources)) continue;
            BlockPos platformPosition = position.func_177977_b();
            IBlockState blockState = world.func_180495_p(platformPosition);
            if (!FarmHelper.bricks.contains((Object)blockState.func_177230_c())) break;
            if (!BlockUtil.isReplaceableBlock(state, world, platformPosition)) {
                this.produce.addAll(BlockUtil.getBlockDrops(world, position));
                world.func_175698_g(position);
                return this.trySetSoil(world, farmHousing, position);
            }
            if (this.isManual) continue;
            if (this.trySetWater(world, farmHousing, position)) {
                return true;
            }
            return this.trySetSoil(world, farmHousing, position);
        }
        return false;
    }

    private boolean maintainWater(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        BlockPos position;
        BlockPos platformPosition;
        IBlockState blockState;
        for (int i = 0; i < extent && FarmHelper.bricks.contains((Object)(blockState = world.func_180495_p(platformPosition = (position = this.translateWithOffset(pos, direction, i)).func_177977_b())).func_177230_c()); ++i) {
            if (!this.trySetWater(world, farmHousing, position)) continue;
            return true;
        }
        return false;
    }

    protected boolean maintainCrops(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        return false;
    }

    private boolean trySetSoil(World world, IFarmHousing farmHousing, BlockPos position) {
        ItemStack[] resources = new ItemStack[]{this.resource};
        if (!farmHousing.getFarmInventory().hasResources(resources)) {
            return false;
        }
        if (!BlockUtil.setBlockWithPlaceSound(world, position, this.ground)) {
            return false;
        }
        farmHousing.getFarmInventory().removeResources(resources);
        return true;
    }

    private boolean trySetWater(World world, IFarmHousing farmHousing, BlockPos position) {
        if (this.isWaterSourceBlock(world, position) || !this.canPlaceWater(world, position)) {
            return false;
        }
        if (!farmHousing.hasLiquid(STACK_WATER)) {
            return false;
        }
        this.produce.addAll(BlockUtil.getBlockDrops(world, position));
        BlockUtil.setBlockWithPlaceSound(world, position, Blocks.field_150355_j.func_176223_P());
        farmHousing.removeLiquid(STACK_WATER);
        return true;
    }

    private boolean canPlaceWater(World world, BlockPos position) {
        int x;
        for (x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos offsetPosition = position.func_177982_a(x, 0, z);
                if (!this.isWaterSourceBlock(world, offsetPosition)) continue;
                return false;
            }
        }
        for (x = -1; x <= 1; ++x) {
            BlockPos offsetPosition = position.func_177982_a(x, 0, 0);
            if (!world.func_175623_d(offsetPosition)) continue;
            return false;
        }
        for (int z = -1; z <= 1; ++z) {
            BlockPos offsetPosition = position.func_177982_a(0, 0, z);
            if (!world.func_175623_d(offsetPosition)) continue;
            return false;
        }
        return true;
    }
}

