/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import forestry.core.items.ItemCrated;
import forestry.core.models.BlankItemModel;
import forestry.core.models.ModelManager;
import forestry.core.models.TRSRBakedModel;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.storage.PluginStorage;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ItemModelMesherForge;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class ModelCrate
extends BlankItemModel {
    private static final Map<String, IBakedModel> crates = Maps.newHashMap();
    private static IModel crateModel;
    private static ModelBlock MODEL_GENERATED;
    private static ModelBlock MODEL_ENTITY;

    public static void initModel(ModelBakeEvent event) {
        try {
            crateModel = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("forestry:item/crate-filled"));
            MODEL_GENERATED = (ModelBlock)ObfuscationReflectionHelper.getPrivateValue(ModelBakery.class, (Object)event.getModelLoader(), (int)17);
            MODEL_ENTITY = (ModelBlock)ObfuscationReflectionHelper.getPrivateValue(ModelBakery.class, (Object)event.getModelLoader(), (int)18);
        }
        catch (Exception e) {
            Log.error("Failed to init the crate model.", e);
        }
        crates.clear();
    }

    private ResourceLocation getItemLocation(ModelResourceLocation modelResource) {
        ResourceLocation resourcelocation = new ResourceLocation(modelResource.toString().replaceAll("#.*", ""));
        return new ResourceLocation(resourcelocation.func_110624_b(), "item/" + resourcelocation.func_110623_a());
    }

    private boolean hasItemModel(ResourceLocation location) {
        try {
            ModelBlock modelBlock = this.loadModel(location);
            if (modelBlock == null) {
                return false;
            }
            return modelBlock.func_178310_f() == MODEL_GENERATED;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ModelBlock loadModel(ResourceLocation location) throws IOException {
        IResource iresource;
        Reader reader;
        block12: {
            void var2_5;
            String s;
            block13: {
                ModelBlock model;
                reader = null;
                iresource = null;
                s = location.func_110623_a();
                if ("builtin/generated".equals(s)) break block12;
                if (!"builtin/entity".equals(s)) break block13;
                ModelBlock modelBlock = model = MODEL_ENTITY;
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(iresource);
                return modelBlock;
            }
            if (s.startsWith("builtin/")) {
                String s1 = s.substring("builtin/".length());
                if (!s1.equals("missing")) throw new FileNotFoundException(location.toString());
                StringReader stringReader = new StringReader("{ \"textures\": {   \"particle\": \"missingno\",   \"missingno\": \"missingno\"}, \"elements\": [ {     \"from\": [ 0, 0, 0 ],     \"to\": [ 16, 16, 16 ],     \"faces\": {         \"down\":  { \"uv\": [ 0, 0, 16, 16 ], \"cullface\": \"down\", \"texture\": \"#missingno\" },         \"up\":    { \"uv\": [ 0, 0, 16, 16 ], \"cullface\": \"up\", \"texture\": \"#missingno\" },         \"north\": { \"uv\": [ 0, 0, 16, 16 ], \"cullface\": \"north\", \"texture\": \"#missingno\" },         \"south\": { \"uv\": [ 0, 0, 16, 16 ], \"cullface\": \"south\", \"texture\": \"#missingno\" },         \"west\":  { \"uv\": [ 0, 0, 16, 16 ], \"cullface\": \"west\", \"texture\": \"#missingno\" },         \"east\":  { \"uv\": [ 0, 0, 16, 16 ], \"cullface\": \"east\", \"texture\": \"#missingno\" }    }}]}");
            } else {
                iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.getModelLocation(location));
                InputStreamReader inputStreamReader = new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8);
            }
            ModelBlock model = ModelBlock.func_178307_a((Reader)var2_5);
            model.field_178317_b = location.toString();
            if (model != null && model.func_178305_e() != null) {
                if (model.func_178305_e().func_110623_a().equals("builtin/generated")) {
                    model.field_178315_d = MODEL_GENERATED;
                } else {
                    try {
                        model.field_178315_d = this.loadModel(model.func_178305_e());
                    }
                    catch (IOException e) {
                        Log.error("Failed to load model.", e);
                    }
                }
            }
            ModelBlock modelBlock = model;
            IOUtils.closeQuietly((Reader)var2_5);
            IOUtils.closeQuietly((Closeable)iresource);
            return modelBlock;
        }
        try {
            ModelBlock model = MODEL_GENERATED;
            return model;
        }
        finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(iresource);
        }
    }

    private ResourceLocation getModelLocation(ResourceLocation resourceLocation) {
        return new ResourceLocation(resourceLocation.func_110624_b(), "models/" + resourceLocation.func_110623_a() + ".json");
    }

    private IBakedModel getModel(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
    }

    @Override
    public ItemOverrideList createOverrides() {
        return new CrateOverrideList();
    }

    private List<IBakedModel> bakeModel(ItemCrated crateItem, IBakedModel crateModel) {
        ArrayList<IBakedModel> models = new ArrayList<IBakedModel>();
        IBakedModel containedModel = this.getModel(crateItem.getContained());
        IdentityHashMap modelResourceLocations = (IdentityHashMap)ObfuscationReflectionHelper.getPrivateValue(ItemModelMesherForge.class, (Object)((ItemModelMesherForge)Minecraft.func_71410_x().func_175599_af().func_175037_a()), (int)0);
        ModelResourceLocation modelResource = (ModelResourceLocation)((TIntObjectHashMap)modelResourceLocations.get(crateItem.getContained().func_77973_b())).get(crateItem.getContained().func_77952_i());
        ResourceLocation location = this.getItemLocation(modelResource);
        models.add(crateModel);
        if (this.hasItemModel(location)) {
            models.add(new TRSRBakedModel(containedModel, -0.0625f, 0.0f, 0.0625f, 0.5f));
            models.add(new TRSRBakedModel(containedModel, -0.0625f, 0.0f, -0.0625f, 0.5f));
        } else {
            models.add(new TRSRBakedModel(containedModel, -0.0625f, 0.0f, 0.0f, 0.5f));
        }
        return models;
    }

    @Override
    public boolean func_177556_c() {
        return false;
    }

    private class CrateBakedModel
    extends BlankItemModel {
        public final List<IBakedModel> models;

        public CrateBakedModel(List<IBakedModel> models) {
            this.models = models;
        }

        @Override
        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (IBakedModel bakedModel : this.models) {
                quads.addAll(bakedModel.func_188616_a(null, side, rand++));
            }
            return quads;
        }
    }

    private class CrateOverrideList
    extends ItemOverrideList {
        public CrateOverrideList() {
            super(Collections.emptyList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            ItemCrated crated = (ItemCrated)stack.func_77973_b();
            String crateUID = ItemStackUtil.getItemNameFromRegistry(crated).func_110623_a();
            if (crates.get(crateUID) == null) {
                IBakedModel baseBaked = ModelCrate.this.getModel(new ItemStack((Item)PluginStorage.items.crate, 1, 1));
                for (BakedQuad quad : baseBaked.func_188616_a(null, null, 0L)) {
                    ObfuscationReflectionHelper.setPrivateValue(BakedQuad.class, (Object)quad, (Object)100, (int)1);
                }
                crates.put(crateUID, new IPerspectiveAwareModel.MapWrapper((IBakedModel)new CrateBakedModel(ModelCrate.this.bakeModel(crated, baseBaked)), ModelManager.getInstance().DEFAULT_ITEM));
            }
            return (IBakedModel)crates.get(crateUID);
        }
    }
}

