/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.worldgen;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.hives.HiveManager;
import forestry.api.apiculture.hives.IHiveDescription;
import forestry.api.apiculture.hives.IHiveGen;
import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.apiculture.PluginApiculture;
import forestry.apiculture.genetics.BeeDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public enum HiveDescription implements IHiveDescription
{
    FOREST(IHiveRegistry.HiveType.FOREST, 3.0f, BeeDefinition.FOREST, HiveManager.genHelper.tree()){

        @Override
        public void postGen(World world, BlockPos pos) {
            super.postGen(world, pos);
            1.postGenFlowers(world, pos, flowerStates);
        }
    }
    ,
    MEADOWS(IHiveRegistry.HiveType.MEADOWS, 1.0f, BeeDefinition.MEADOWS, HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c})){

        @Override
        public void postGen(World world, BlockPos pos) {
            super.postGen(world, pos);
            2.postGenFlowers(world, pos, flowerStates);
        }
    }
    ,
    DESERT(IHiveRegistry.HiveType.DESERT, 1.0f, BeeDefinition.MODEST, HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150354_m, Blocks.field_150322_A})){

        @Override
        public void postGen(World world, BlockPos pos) {
            super.postGen(world, pos);
            3.postGenFlowers(world, pos, cactusStates);
        }
    }
    ,
    JUNGLE(IHiveRegistry.HiveType.JUNGLE, 6.0f, BeeDefinition.TROPICAL, HiveManager.genHelper.tree()),
    END(IHiveRegistry.HiveType.END, 6.0f, BeeDefinition.ENDED, HiveManager.genHelper.ground(Blocks.field_150377_bs, Blocks.field_185772_cY)){

        @Override
        public boolean isGoodBiome(BiomeGenBase biome) {
            return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END);
        }
    }
    ,
    SNOW(IHiveRegistry.HiveType.SNOW, 2.0f, BeeDefinition.WINTRY, HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150433_aE})){

        @Override
        public void postGen(World world, BlockPos pos) {
            if (world.func_175623_d(pos.func_177982_a(0, 1, 0))) {
                world.func_180501_a(pos.func_177982_a(0, 1, 0), Blocks.field_150431_aC.func_176223_P(), 2);
            }
            5.postGenFlowers(world, pos, flowerStates);
        }
    }
    ,
    SWAMP(IHiveRegistry.HiveType.SWAMP, 2.0f, BeeDefinition.MARSHY, HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c})){

        @Override
        public void postGen(World world, BlockPos pos) {
            super.postGen(world, pos);
            6.postGenFlowers(world, pos, mushroomStates);
        }
    };

    private static final IHiveGen groundGen;
    private static final List<IBlockState> flowerStates;
    private static final List<IBlockState> mushroomStates;
    private static final List<IBlockState> cactusStates;
    private final IBlockState blockState;
    private final float genChance;
    private final IBeeGenome beeGenome;
    private final IHiveGen hiveGen;

    private HiveDescription(IHiveRegistry.HiveType hiveType, float genChance, BeeDefinition beeTemplate, IHiveGen hiveGen) {
        this.blockState = PluginApiculture.blocks.beehives.getStateForType(hiveType);
        this.genChance = genChance;
        this.beeGenome = beeTemplate.getGenome();
        this.hiveGen = hiveGen;
    }

    @Override
    public IHiveGen getHiveGen() {
        return this.hiveGen;
    }

    @Override
    public IBlockState getBlockState() {
        return this.blockState;
    }

    @Override
    public boolean isGoodBiome(BiomeGenBase biome) {
        return !BiomeHelper.isBiomeHellish(biome);
    }

    @Override
    public boolean isGoodHumidity(EnumHumidity humidity) {
        EnumHumidity idealHumidity = this.beeGenome.getPrimary().getHumidity();
        EnumTolerance humidityTolerance = this.beeGenome.getToleranceHumid();
        return AlleleManager.climateHelper.isWithinLimits(humidity, idealHumidity, humidityTolerance);
    }

    @Override
    public boolean isGoodTemperature(EnumTemperature temperature) {
        EnumTemperature idealTemperature = this.beeGenome.getPrimary().getTemperature();
        EnumTolerance temperatureTolerance = this.beeGenome.getToleranceTemp();
        return AlleleManager.climateHelper.isWithinLimits(temperature, idealTemperature, temperatureTolerance);
    }

    @Override
    public float getGenChance() {
        return this.genChance;
    }

    @Override
    public void postGen(World world, BlockPos pos) {
    }

    protected static void postGenFlowers(World world, BlockPos hivePos, List<IBlockState> flowerStates) {
        int plantedCount = 0;
        for (int i = 0; i < 10; ++i) {
            IBlockState state;
            Block block;
            int xOffset = world.field_73012_v.nextInt(8) - 4;
            int zOffset = world.field_73012_v.nextInt(8) - 4;
            BlockPos blockPos = hivePos.func_177982_a(xOffset, 0, zOffset);
            if (xOffset == 0 && zOffset == 0 || !world.func_175667_e(blockPos) || (blockPos = groundGen.getPosForHive(world, blockPos.func_177958_n(), blockPos.func_177952_p())) == null || !(block = (state = flowerStates.get(world.field_73012_v.nextInt(flowerStates.size()))).func_177230_c()).func_176196_c(world, blockPos)) continue;
            world.func_175656_a(blockPos, state);
            if (++plantedCount >= 3) break;
        }
    }

    static {
        groundGen = HiveManager.genHelper.ground(new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150433_aE, Blocks.field_150354_m, Blocks.field_150322_A});
        flowerStates = new ArrayList<IBlockState>();
        mushroomStates = new ArrayList<IBlockState>();
        cactusStates = Collections.singletonList(Blocks.field_150434_aF.func_176223_P());
        flowerStates.addAll((Collection<IBlockState>)Blocks.field_150328_O.func_176194_O().func_177619_a());
        flowerStates.addAll((Collection<IBlockState>)Blocks.field_150327_N.func_176194_O().func_177619_a());
        mushroomStates.add(Blocks.field_150337_Q.func_176223_P());
        mushroomStates.add(Blocks.field_150338_P.func_176223_P());
    }
}

