/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.flowers;

import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.core.utils.Translator;
import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class FlowerProvider
implements IFlowerProvider {
    private final String flowerType;
    private final String unlocalizedDescription;

    public FlowerProvider(String flowerType, String unlocalizedDescription) {
        this.flowerType = flowerType;
        this.unlocalizedDescription = unlocalizedDescription;
    }

    @Override
    public String getFlowerType() {
        return this.flowerType;
    }

    @Override
    public boolean isAcceptedPollinatable(World world, ICheckPollinatable pollinatable) {
        EnumSet<EnumPlantType> plantTypes = pollinatable.getPlantType();
        switch (this.flowerType) {
            case "flowersNether": {
                return plantTypes.contains(EnumPlantType.Nether);
            }
            case "flowersCacti": {
                return plantTypes.contains(EnumPlantType.Desert);
            }
        }
        return plantTypes.size() > 1 || !plantTypes.contains(EnumPlantType.Nether);
    }

    @Override
    public String getDescription() {
        return Translator.translateToLocal(this.unlocalizedDescription);
    }

    @Override
    public ItemStack[] affectProducts(World world, IIndividual individual, BlockPos pos, ItemStack[] products) {
        return products;
    }
}

