/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.arboriculture;

import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IFruitFamily;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IFruitProvider {
    public IFruitFamily getFamily();

    public int getColour(ITreeGenome var1, IBlockAccess var2, BlockPos var3, int var4);

    public int getDecorativeColor();

    public boolean markAsFruitLeaf(ITreeGenome var1, World var2, BlockPos var3);

    public int getRipeningPeriod();

    @Nonnull
    public Map<ItemStack, Float> getProducts();

    @Nonnull
    public Map<ItemStack, Float> getSpecialty();

    @Nonnull
    public List<ItemStack> getFruits(ITreeGenome var1, World var2, BlockPos var3, int var4);

    public String getDescription();

    @Nullable
    public String getModelName();

    @Nonnull
    public String getModID();

    public short getSpriteIndex(ITreeGenome var1, IBlockAccess var2, BlockPos var3, int var4, boolean var5);

    public short getDecorativeSpriteIndex();

    public boolean requiresFruitBlocks();

    public boolean trySpawnFruitBlock(ITreeGenome var1, World var2, Random var3, BlockPos var4);

    @SideOnly(value=Side.CLIENT)
    public void registerSprites();
}

