/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.farming.logic.CropDestroy;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableGourd
implements IFarmable {
    private final ItemStack seed;
    private final Block stem;
    private final Block fruit;

    public FarmableGourd(ItemStack seed, Block stem, Block fruit) {
        this.seed = seed;
        this.stem = stem;
        this.fruit = fruit;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        return blockState.func_177230_c() == this.stem;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() != this.fruit) {
            return null;
        }
        return new CropDestroy(world, blockState, pos, null);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStack.func_179545_c((ItemStack)itemstack, (ItemStack)this.seed);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        return world.func_175656_a(pos, this.stem.func_176223_P());
    }
}

