/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.farming.logic.CropDestroy;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableAgingCrop
implements IFarmable {
    protected final ItemStack germling;
    protected final Block cropBlock;
    protected final IProperty<Integer> ageProperty;
    protected final int minHarvestAge;
    @Nullable
    protected final Integer replantAge;

    public FarmableAgingCrop(ItemStack germling, Block cropBlock, IProperty<Integer> ageProperty, int minHarvestAge) {
        this(germling, cropBlock, ageProperty, minHarvestAge, null);
    }

    public FarmableAgingCrop(ItemStack germling, Block cropBlock, IProperty<Integer> ageProperty, int minHarvestAge, @Nullable Integer replantAge) {
        this.germling = germling;
        this.cropBlock = cropBlock;
        this.ageProperty = ageProperty;
        this.minHarvestAge = minHarvestAge;
        this.replantAge = replantAge;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        return blockState.func_177230_c() == this.cropBlock && (Integer)blockState.func_177229_b(this.ageProperty) < this.minHarvestAge;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() != this.cropBlock) {
            return null;
        }
        if ((Integer)blockState.func_177229_b(this.ageProperty) < this.minHarvestAge) {
            return null;
        }
        if (this.replantAge != null) {
            IBlockState replantState = this.cropBlock.func_176223_P().func_177226_a(this.ageProperty, (Comparable)this.replantAge);
            return new CropDestroy(world, blockState, pos, replantState);
        }
        return new CropDestroy(world, blockState, pos, null);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStack.func_179545_c((ItemStack)this.germling, (ItemStack)itemstack);
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        IBlockState plantedState = this.cropBlock.func_176223_P().func_177226_a(this.ageProperty, (Comparable)Integer.valueOf(0));
        return world.func_175656_a(pos, plantedState);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

