/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import forestry.api.core.IErrorLogic;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.fluids.tanks.FilteredTank;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.core.inventory.wrappers.InventoryMapper;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.IItemStackDisplay;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.PlayerUtil;
import forestry.factory.gui.ContainerCarpenter;
import forestry.factory.gui.GuiCarpenter;
import forestry.factory.inventory.InventoryCarpenter;
import forestry.factory.inventory.InventoryGhostCrafting;
import forestry.factory.recipes.CarpenterRecipeManager;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileCarpenter
extends TilePowered
implements ISidedInventory,
ILiquidTankTile,
IFluidHandler,
IItemStackDisplay {
    private static final int TICKS_PER_RECIPE_TIME = 1;
    private static final int ENERGY_PER_WORK_CYCLE = 2040;
    private static final int ENERGY_PER_RECIPE_TIME = 204;
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    private final InventoryAdapterTile craftingInventory;
    private final InventoryCraftResult craftPreviewInventory;
    @Nullable
    private ICarpenterRecipe currentRecipe;

    private ItemStack getBoxStack() {
        return this.getInternalInventory().func_70301_a(9);
    }

    public TileCarpenter() {
        super("carpenter", 1100, 4000);
        this.setEnergyPerWorkCycle(2040);
        this.resourceTank = new FilteredTank(10000, CarpenterRecipeManager.getRecipeFluids());
        this.craftingInventory = new InventoryGhostCrafting<TileCarpenter>(this, 10);
        this.craftPreviewInventory = new InventoryCraftResult();
        this.setInternalInventory(new InventoryCarpenter(this));
        this.tankManager = new TankManager(this, this.resourceTank);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        this.craftingInventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        this.craftingInventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    public void checkRecipe() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!CarpenterRecipeManager.matches(this.currentRecipe, this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory)) {
            this.currentRecipe = CarpenterRecipeManager.findMatchingRecipe(this.resourceTank.getFluid(), this.getBoxStack(), (IInventory)this.craftingInventory);
            if (this.currentRecipe != null) {
                int recipeTime = this.currentRecipe.getPackagingTime();
                this.setTicksPerWorkCycle(recipeTime * 1);
                this.setEnergyPerWorkCycle(recipeTime * 204);
                ItemStack craftingResult = this.currentRecipe.getCraftingGridRecipe().func_77571_b();
                this.craftPreviewInventory.func_70299_a(0, craftingResult);
            } else {
                this.craftPreviewInventory.func_70299_a(0, null);
            }
        }
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 11);
        }
    }

    @Override
    public boolean workCycle() {
        if (!this.removeLiquidResources(true)) {
            return false;
        }
        if (!this.removeItemResources(true)) {
            return false;
        }
        ItemStack pendingProduct = this.currentRecipe.getCraftingGridRecipe().func_77571_b();
        InventoryUtil.tryAddStack((IInventory)this, pendingProduct, 10, 1, true);
        return true;
    }

    private boolean removeLiquidResources(boolean doRemove) {
        if (this.currentRecipe == null) {
            return true;
        }
        FluidStack fluid = this.currentRecipe.getFluidResource();
        if (fluid != null) {
            if (!this.resourceTank.canDrain(fluid)) {
                return false;
            }
            if (doRemove) {
                this.resourceTank.drain(fluid.amount, true);
            }
        }
        return true;
    }

    private boolean removeItemResources(boolean doRemove) {
        if (this.currentRecipe == null) {
            return true;
        }
        if (this.currentRecipe.getBox() != null) {
            ItemStack box = this.func_70301_a(9);
            if (box == null || box.field_77994_a == 0) {
                return false;
            }
            if (doRemove) {
                this.func_70298_a(9, 1);
            }
        }
        EntityPlayer player = PlayerUtil.getPlayer(this.field_145850_b, this.getAccessHandler().getOwner());
        ItemStack[] craftingSets = InventoryUtil.getStacks((IInventory)this.craftingInventory, 0, 9);
        InventoryMapper inventory = new InventoryMapper((IInventory)this.getInternalInventory(), 12, 18);
        return InventoryUtil.removeSets(inventory, 1, craftingSets, player, true, true, false, doRemove);
    }

    @Override
    public boolean hasWork() {
        if (this.updateOnInterval(20)) {
            this.checkRecipe();
        }
        boolean hasRecipe = this.currentRecipe != null;
        boolean hasLiquidResources = true;
        boolean hasItemResources = true;
        boolean canAdd = true;
        if (hasRecipe) {
            hasLiquidResources = this.removeLiquidResources(false);
            hasItemResources = this.removeItemResources(false);
            ItemStack pendingProduct = this.currentRecipe.getCraftingGridRecipe().func_77571_b();
            canAdd = InventoryUtil.tryAddStack((IInventory)this, pendingProduct, 10, 1, true, false);
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NO_RECIPE);
        errorLogic.setCondition(!hasLiquidResources, EnumErrorCode.NO_RESOURCE_LIQUID);
        errorLogic.setCondition(!hasItemResources, EnumErrorCode.NO_RESOURCE_INVENTORY);
        errorLogic.setCondition(!canAdd, EnumErrorCode.NO_SPACE_INVENTORY);
        return hasRecipe && hasItemResources && hasLiquidResources && canAdd;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    public IInventory getCraftingInventory() {
        return this.craftingInventory;
    }

    public IInventory getCraftPreviewInventory() {
        return this.craftPreviewInventory;
    }

    @Override
    public void handleItemStackForDisplay(ItemStack itemStack) {
        this.craftPreviewInventory.func_70299_a(0, itemStack);
    }

    public int fill(EnumFacing direction, FluidStack resource, boolean doFill) {
        return this.tankManager.fill(direction, resource, doFill);
    }

    @Override
    @Nonnull
    public TankManager getTankManager() {
        return this.tankManager;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.tankManager.drain(from, resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.tankManager.drain(from, maxDrain, doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.tankManager.canFill(from, fluid);
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.tankManager.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return this.tankManager.getTankInfo(from);
    }

    @Override
    public Object getGui(EntityPlayer player, int data) {
        return new GuiCarpenter(player.field_71071_by, this);
    }

    @Override
    public Object getContainer(EntityPlayer player, int data) {
        return new ContainerCarpenter(player.field_71071_by, this);
    }
}

