/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network.packets;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import java.io.IOException;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketFXSignal
extends PacketCoordinates
implements IForestryPacketClient {
    private VisualFXType visualFX;
    private SoundFXType soundFX;
    private IBlockState state;

    public PacketFXSignal() {
    }

    public PacketFXSignal(VisualFXType type, BlockPos pos, IBlockState state) {
        this(type, SoundFXType.NONE, pos, state);
    }

    public PacketFXSignal(SoundFXType type, BlockPos pos, IBlockState state) {
        this(VisualFXType.NONE, type, pos, state);
    }

    public PacketFXSignal(VisualFXType visualFX, SoundFXType soundFX, BlockPos pos, IBlockState state) {
        super(pos);
        this.visualFX = visualFX;
        this.soundFX = soundFX;
        this.state = state;
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        data.writeShort(this.visualFX.ordinal());
        data.writeShort(this.soundFX.ordinal());
        data.writeInt(this.state.func_177230_c().func_176201_c(this.state));
        data.writeUTF(ItemStackUtil.getBlockNameFromRegistryAsSting(this.state.func_177230_c()));
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        super.readData(data);
        this.visualFX = VisualFXType.values()[data.readShort()];
        this.soundFX = SoundFXType.values()[data.readShort()];
        int meta = data.readInt();
        this.state = ItemStackUtil.getBlockFromRegistry(data.readUTF()).func_176203_a(meta);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        World renderWorld = Proxies.common.getRenderWorld();
        if (this.visualFX != VisualFXType.NONE) {
            Proxies.common.addBlockDestroyEffects(renderWorld, this.getPos(), this.state);
        }
        if (this.soundFX != SoundFXType.NONE) {
            if (this.soundFX == SoundFXType.BLOCK_DESTROY) {
                Proxies.common.playBlockBreakSoundFX(renderWorld, this.getPos(), this.state);
            } else if (this.soundFX == SoundFXType.BLOCK_PLACE) {
                Proxies.common.playBlockPlaceSoundFX(renderWorld, this.getPos(), this.state);
            } else {
                Proxies.common.playSoundFX(renderWorld, this.getPos(), this.soundFX.soundEvent, SoundCategory.BLOCKS, this.soundFX.volume, this.soundFX.pitch);
            }
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.FX_SIGNAL;
    }

    public static enum SoundFXType {
        NONE(null),
        BLOCK_DESTROY(null),
        BLOCK_PLACE(null),
        LEAF(Blocks.field_150362_t.func_185467_w().func_185844_d()),
        LOG(Blocks.field_150364_r.func_185467_w().func_185845_c()),
        DIRT(Blocks.field_150346_d.func_185467_w().func_185845_c());

        public final SoundEvent soundEvent;
        public final float volume;
        public final float pitch;

        private SoundFXType(SoundEvent soundEvent) {
            this.soundEvent = soundEvent;
            this.volume = 1.0f;
            this.pitch = 1.0f;
        }
    }

    public static enum VisualFXType {
        NONE,
        BLOCK_DESTROY,
        SAPLING_PLACE;

    }
}

