/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.farming.logic.CropDestroy;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FarmableGenericSapling
implements IFarmable {
    protected final ItemStack germling;
    protected final IBlockState plantedState;
    private final boolean replant;
    private final ItemStack[] windfall;

    public FarmableGenericSapling(ItemStack germling, IBlockState plantedState, boolean replant, ItemStack ... windfall) {
        this.germling = germling;
        this.plantedState = plantedState;
        this.replant = replant;
        this.windfall = windfall;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this.plantedState.func_177230_c();
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos, IBlockState blockState) {
        Block block = blockState.func_177230_c();
        if (!block.isWood((IBlockAccess)world, pos)) {
            return null;
        }
        if (this.replant) {
            return new CropDestroy(world, blockState, pos, this.plantedState);
        }
        return new CropDestroy(world, blockState, pos, null);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStack.func_179545_c((ItemStack)this.germling, (ItemStack)itemstack);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        for (ItemStack drop : this.windfall) {
            if (!drop.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        return germling.func_77946_l().func_179546_a(player, world, pos.func_177977_b(), EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f) == EnumActionResult.SUCCESS;
    }
}

