/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import com.google.common.base.Predicate;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.core.entities.EntitySelector;
import forestry.core.utils.VectUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class FarmLogic
implements IFarmLogic {
    private final EntitySelectorFarm entitySelectorFarm = new EntitySelectorFarm(this);
    protected boolean isManual;

    @Override
    public FarmLogic setManual(boolean flag) {
        this.isManual = flag;
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTextureMap() {
        return TextureMap.field_110575_b;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ItemStack getStack() {
        return new ItemStack(this.getItem(), 1, this.getMetadata());
    }

    @SideOnly(value=Side.CLIENT)
    public abstract Item getItem();

    @SideOnly(value=Side.CLIENT)
    public int getMetadata() {
        return 0;
    }

    public abstract boolean isAcceptedWindfall(ItemStack var1);

    @Deprecated
    protected final boolean isAirBlock(@Nonnull Block block, @Nonnull IBlockState blockState, @Nonnull World world, @Nonnull BlockPos blockPos) {
        return block.isAir(blockState, (IBlockAccess)world, blockPos);
    }

    protected final boolean isWaterSourceBlock(World world, BlockPos position) {
        IBlockState blockState = world.func_180495_p(position);
        Block block = blockState.func_177230_c();
        return block == Blocks.field_150355_j;
    }

    protected final BlockPos translateWithOffset(BlockPos pos, FarmDirection farmDirection, int step) {
        return VectUtil.scale(farmDirection.getFacing().func_176730_m(), step).func_177971_a((Vec3i)pos);
    }

    private static AxisAlignedBB getHarvestBox(World world, IFarmHousing farmHousing, boolean toWorldHeight) {
        BlockPos coords = farmHousing.getCoords();
        Vec3i area = farmHousing.getArea();
        Vec3i offset = farmHousing.getOffset();
        BlockPos min = coords.func_177971_a(offset);
        BlockPos max = min.func_177971_a(area);
        int maxY = max.func_177956_o();
        if (toWorldHeight) {
            maxY = world.func_72800_K();
        }
        return new AxisAlignedBB((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p(), (double)max.func_177958_n(), (double)maxY, (double)max.func_177952_p());
    }

    protected List<ItemStack> collectEntityItems(World world, IFarmHousing farmHousing, boolean toWorldHeight) {
        AxisAlignedBB harvestBox = FarmLogic.getHarvestBox(world, farmHousing, toWorldHeight);
        List entityItems = world.func_175647_a(this.entitySelectorFarm.getEntityClass(), harvestBox, (Predicate)this.entitySelectorFarm);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (EntityItem entity : entityItems) {
            ItemStack contained = entity.func_92059_d();
            stacks.add(contained.func_77946_l());
            entity.func_70106_y();
        }
        return stacks;
    }

    private static class EntitySelectorFarm
    extends EntitySelector<EntityItem> {
        private final FarmLogic farmLogic;

        public EntitySelectorFarm(FarmLogic farmLogic) {
            super(EntityItem.class);
            this.farmLogic = farmLogic;
        }

        @Override
        protected boolean isEntityApplicableTyped(EntityItem entity) {
            if (entity.field_70128_L) {
                return false;
            }
            ItemStack contained = entity.func_92059_d();
            return this.farmLogic.isAcceptedGermling(contained) || this.farmLogic.isAcceptedWindfall(contained);
        }
    }
}

