/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.genetics.IFruitBearer;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.farming.logic.Crop;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CropFruit
extends Crop {
    public CropFruit(World world, BlockPos position) {
        super(world, position);
    }

    @Override
    protected boolean isCrop(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof IFruitBearer)) {
            return false;
        }
        IFruitBearer bearer = (IFruitBearer)tile;
        if (!bearer.hasFruit()) {
            return false;
        }
        return !(bearer.getRipeness() < 0.9f);
    }

    @Override
    protected Collection<ItemStack> harvestBlock(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof IFruitBearer)) {
            return Collections.emptySet();
        }
        IBlockState blockState = world.func_180495_p(pos);
        Proxies.common.sendFXSignal(PacketFXSignal.VisualFXType.BLOCK_DESTROY, PacketFXSignal.SoundFXType.LEAF, world, pos, blockState);
        return ((IFruitBearer)tile).pickFruit(null);
    }
}

