/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGrowthConditions;
import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.core.ForestryAPI;
import forestry.arboriculture.tiles.TileSapling;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.Translator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GrowthProvider
implements IGrowthProvider {
    @Override
    @Nullable
    public BlockPos canGrow(ITreeGenome genome, World world, BlockPos pos, int expectedGirth, int expectedHeight) {
        BlockPos growthPos = GrowthProvider.hasSufficientSaplingsAroundSapling(genome, world, pos, expectedGirth);
        if (growthPos == null) {
            return null;
        }
        if (!GrowthProvider.hasRoom(world, growthPos, expectedGirth, expectedHeight)) {
            return null;
        }
        if (this.getGrowthConditions(genome, world, growthPos) == EnumGrowthConditions.HOSTILE) {
            return null;
        }
        return growthPos;
    }

    @Override
    public EnumGrowthConditions getGrowthConditions(ITreeGenome genome, World world, BlockPos pos) {
        return GrowthProvider.getConditionFromLight(world, pos);
    }

    @Override
    public String getDescription() {
        return Translator.translateToLocal("for.growth.normal");
    }

    @Override
    public String[] getInfo() {
        return new String[0];
    }

    protected static EnumGrowthConditions getConditionsFromRainfall(World world, BlockPos pos, float min, float max) {
        float humidity = ForestryAPI.climateManager.getHumidity(world, pos);
        if (humidity < min || humidity > max) {
            return EnumGrowthConditions.HOSTILE;
        }
        return EnumGrowthConditions.EXCELLENT;
    }

    protected static EnumGrowthConditions getConditionsFromTemperature(World world, BlockPos pos, float min, float max) {
        float biomeTemperature = ForestryAPI.climateManager.getTemperature(world, pos);
        if (biomeTemperature < min || biomeTemperature > max) {
            return EnumGrowthConditions.HOSTILE;
        }
        return EnumGrowthConditions.EXCELLENT;
    }

    protected static EnumGrowthConditions getConditionFromLight(World world, BlockPos pos) {
        int lightValue = world.func_175671_l(pos.func_177982_a(0, 1, 0));
        if (lightValue > 13) {
            return EnumGrowthConditions.EXCELLENT;
        }
        if (lightValue > 11) {
            return EnumGrowthConditions.GOOD;
        }
        if (lightValue > 8) {
            return EnumGrowthConditions.NORMAL;
        }
        if (lightValue > 6) {
            return EnumGrowthConditions.PALTRY;
        }
        return EnumGrowthConditions.HOSTILE;
    }

    private static boolean hasRoom(World world, BlockPos pos, int expectedGirth, int expectedHeight) {
        Vec3i area = new Vec3i(expectedGirth, expectedHeight + 1, expectedGirth);
        return GrowthProvider.checkArea(world, pos.func_177984_a(), area);
    }

    private static boolean checkArea(World world, BlockPos start, Vec3i area) {
        for (int x = 0; x < area.func_177958_n(); ++x) {
            for (int y = 0; y < area.func_177956_o(); ++y) {
                for (int z = 0; z < area.func_177952_p(); ++z) {
                    BlockPos pos = start.func_177982_a(x, y, z);
                    IBlockState blockState = world.func_180495_p(pos);
                    if (blockState.func_177230_c().func_176200_f((IBlockAccess)world, pos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private static BlockPos hasSufficientSaplingsAroundSapling(ITreeGenome genome, World world, BlockPos saplingPos, int expectedGirth) {
        int checkSize = expectedGirth * 2 - 1;
        int offset = expectedGirth - 1;
        HashMap<BlockPos, Boolean> knownSaplings = new HashMap<BlockPos, Boolean>(checkSize * checkSize);
        for (int x = -offset; x <= 0; ++x) {
            for (int z = -offset; z <= 0; ++z) {
                BlockPos startPos = saplingPos.func_177982_a(x, 0, z);
                if (!GrowthProvider.checkForSaplings(genome, world, startPos, expectedGirth, knownSaplings)) continue;
                return startPos;
            }
        }
        return null;
    }

    private static boolean checkForSaplings(ITreeGenome genome, World world, BlockPos startPos, int girth, Map<BlockPos, Boolean> knownSaplings) {
        for (int x = 0; x < girth; ++x) {
            for (int z = 0; z < girth; ++z) {
                BlockPos checkPos = startPos.func_177982_a(x, 0, z);
                Boolean knownSapling = knownSaplings.get(checkPos);
                if (knownSapling == null) {
                    knownSapling = GrowthProvider.isSapling(genome, world, checkPos);
                    knownSaplings.put(checkPos, knownSapling);
                }
                if (knownSapling.booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isSapling(ITreeGenome genome, World world, BlockPos pos) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        if (world.func_175623_d(pos)) {
            return false;
        }
        TileSapling sapling = TileUtil.getTile((IBlockAccess)world, pos, TileSapling.class);
        if (sapling == null) {
            return false;
        }
        ITree tree = sapling.getTree();
        return tree != null && tree.getGenome().getPrimary().getUID().equals(genome.getPrimary().getUID());
    }
}

