/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.VillagerArboristTrades;
import forestry.arboriculture.WoodAccess;
import forestry.arboriculture.blocks.BlockArbLog;
import forestry.arboriculture.blocks.BlockArbSlab;
import forestry.arboriculture.blocks.BlockRegistryArboriculture;
import forestry.arboriculture.commands.CommandTree;
import forestry.arboriculture.genetics.TreeBranchDefinition;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeFactory;
import forestry.arboriculture.genetics.TreeMutationFactory;
import forestry.arboriculture.genetics.TreeRoot;
import forestry.arboriculture.genetics.TreekeepingMode;
import forestry.arboriculture.genetics.alleles.AlleleFruit;
import forestry.arboriculture.genetics.alleles.AlleleGrowth;
import forestry.arboriculture.genetics.alleles.AlleleLeafEffect;
import forestry.arboriculture.items.ItemRegistryArboriculture;
import forestry.arboriculture.models.TextureLeaves;
import forestry.arboriculture.network.PacketRegistryArboriculture;
import forestry.arboriculture.proxy.ProxyArboriculture;
import forestry.arboriculture.tiles.TileFruitPod;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.arboriculture.tiles.TileSapling;
import forestry.core.PluginCore;
import forestry.core.config.Config;
import forestry.core.fluids.Fluids;
import forestry.core.genetics.alleles.AllelePlantType;
import forestry.core.items.ItemFruit;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.IMCUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.VillagerTradeLists;
import forestry.factory.recipes.FabricatorRecipe;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ForestryPlugin(pluginID="forestry.arboriculture", name="Arboriculture", author="Binnie & SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.arboriculture.description")
public class PluginArboriculture
extends BlankForestryPlugin {
    @SidedProxy(clientSide="forestry.arboriculture.proxy.ProxyArboricultureClient", serverSide="forestry.arboriculture.proxy.ProxyArboriculture")
    public static ProxyArboriculture proxy;
    public static String treekeepingMode;
    public static final List<Block> validFences;
    public static ItemRegistryArboriculture items;
    public static BlockRegistryArboriculture blocks;
    public static VillagerRegistry.VillagerProfession villagerArborist;

    @Override
    public void setupAPI() {
        TreeManager.treeFactory = new TreeFactory();
        TreeManager.treeMutationFactory = new TreeMutationFactory();
        TreeManager.woodAccess = new WoodAccess();
        TreeManager.treeRoot = new TreeRoot();
        AlleleManager.alleleRegistry.registerSpeciesRoot(TreeManager.treeRoot);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.easy);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.normal);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.hard);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.hardcore);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.insane);
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryArboriculture();
        blocks = new BlockRegistryArboriculture();
    }

    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        WoodAccess.registerLogs(PluginArboriculture.blocks.logs);
        WoodAccess.registerPlanks(PluginArboriculture.blocks.planks);
        WoodAccess.registerSlabs(PluginArboriculture.blocks.slabs);
        WoodAccess.registerFences(PluginArboriculture.blocks.fences);
        WoodAccess.registerFenceGates(PluginArboriculture.blocks.fenceGates);
        WoodAccess.registerStairs(PluginArboriculture.blocks.stairs);
        WoodAccess.registerDoors(PluginArboriculture.blocks.doors);
        WoodAccess.registerLogs(PluginArboriculture.blocks.logsFireproof);
        WoodAccess.registerPlanks(PluginArboriculture.blocks.planksFireproof);
        WoodAccess.registerSlabs(PluginArboriculture.blocks.slabsFireproof);
        WoodAccess.registerFences(PluginArboriculture.blocks.fencesFireproof);
        WoodAccess.registerFenceGates(PluginArboriculture.blocks.fenceGatesFireproof);
        WoodAccess.registerStairs(PluginArboriculture.blocks.stairsFireproof);
        proxy.initializeModels();
        PluginCore.rootCommand.addChildCommand(new CommandTree());
    }

    @Override
    public void addLootPoolNames(Set<String> lootPoolNames) {
        super.addLootPoolNames(lootPoolNames);
        lootPoolNames.add("forestry_arboriculture_items");
    }

    @Override
    public void doInit() {
        super.doInit();
        PluginArboriculture.createAlleles();
        TreeDefinition.initTrees();
        PluginArboriculture.registerErsatzGenomes();
        GameRegistry.registerTileEntity(TileSapling.class, (String)"forestry.Sapling");
        GameRegistry.registerTileEntity(TileLeaves.class, (String)"forestry.Leaves");
        GameRegistry.registerTileEntity(TileFruitPod.class, (String)"forestry.Pods");
        PluginArboriculture.blocks.treeChest.init();
        if (Config.enableVillagers) {
            villagerArborist = new VillagerRegistry.VillagerProfession("forestry:arborist", "forestry:textures/entity/lumberjack.png");
            VillagerRegistry.instance().register(villagerArborist);
            VillagerRegistry.VillagerCareer arboristCareer = new VillagerRegistry.VillagerCareer(villagerArborist, "arborist");
            arboristCareer.addTrade(1, new EntityVillager.ITradeList[]{new VillagerArboristTrades.GivePlanksForEmeralds(new EntityVillager.PriceInfo(1, 1), new EntityVillager.PriceInfo(10, 32)), new VillagerArboristTrades.GivePollenForEmeralds(new EntityVillager.PriceInfo(1, 1), new EntityVillager.PriceInfo(1, 3), EnumGermlingType.SAPLING, 4)});
            arboristCareer.addTrade(2, new EntityVillager.ITradeList[]{new VillagerArboristTrades.GivePlanksForEmeralds(new EntityVillager.PriceInfo(1, 1), new EntityVillager.PriceInfo(10, 32)), new VillagerTradeLists.GiveItemForEmeralds(new EntityVillager.PriceInfo(1, 4), PluginArboriculture.items.grafterProven.getItemStack(), new EntityVillager.PriceInfo(1, 1)), new VillagerArboristTrades.GivePollenForEmeralds(new EntityVillager.PriceInfo(2, 3), new EntityVillager.PriceInfo(1, 1), EnumGermlingType.POLLEN, 6)});
            arboristCareer.addTrade(3, new EntityVillager.ITradeList[]{new VillagerArboristTrades.GiveLogsForEmeralds(new EntityVillager.PriceInfo(2, 5), new EntityVillager.PriceInfo(6, 18)), new VillagerArboristTrades.GiveLogsForEmeralds(new EntityVillager.PriceInfo(2, 5), new EntityVillager.PriceInfo(6, 18))});
            arboristCareer.addTrade(4, new EntityVillager.ITradeList[]{new VillagerArboristTrades.GivePollenForEmeralds(new EntityVillager.PriceInfo(5, 20), new EntityVillager.PriceInfo(1, 1), EnumGermlingType.POLLEN, 10), new VillagerArboristTrades.GivePollenForEmeralds(new EntityVillager.PriceInfo(5, 20), new EntityVillager.PriceInfo(1, 1), EnumGermlingType.SAPLING, 10)});
        }
    }

    @Override
    public void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        crateRegistry.registerCrate(ItemFruit.EnumFruit.CHERRY.getStack());
        crateRegistry.registerCrate(ItemFruit.EnumFruit.WALNUT.getStack());
        crateRegistry.registerCrate(ItemFruit.EnumFruit.CHESTNUT.getStack());
        crateRegistry.registerCrate(ItemFruit.EnumFruit.LEMON.getStack());
        crateRegistry.registerCrate(ItemFruit.EnumFruit.PLUM.getStack());
        crateRegistry.registerCrate(ItemFruit.EnumFruit.PAPAYA.getStack());
        crateRegistry.registerCrate(ItemFruit.EnumFruit.DATES.getStack());
    }

    @Override
    public void registerRecipes() {
        for (BlockArbLog log : PluginArboriculture.blocks.logs) {
            ItemStack logInput = new ItemStack((Block)log, 1, Short.MAX_VALUE);
            ItemStack coalOutput = new ItemStack(Items.field_151044_h, 1, 1);
            RecipeUtil.addSmelting(logInput, coalOutput, 0.15f);
        }
        for (EnumWoodType woodType : EnumWoodType.VALUES) {
            ItemStack planks = TreeManager.woodAccess.getPlanks(woodType, false);
            ItemStack logs = TreeManager.woodAccess.getLog(woodType, false);
            ItemStack slabs = TreeManager.woodAccess.getSlab(woodType, false);
            ItemStack fences = TreeManager.woodAccess.getFence(woodType, false);
            ItemStack fenceGates = TreeManager.woodAccess.getFenceGate(woodType, false);
            ItemStack stairs = TreeManager.woodAccess.getStairs(woodType, false);
            ItemStack doors = TreeManager.woodAccess.getDoor(woodType);
            ItemStack fireproofPlanks = TreeManager.woodAccess.getPlanks(woodType, true);
            ItemStack fireproofLogs = TreeManager.woodAccess.getLog(woodType, true);
            ItemStack fireproofSlabs = TreeManager.woodAccess.getSlab(woodType, true);
            ItemStack fireproofFences = TreeManager.woodAccess.getFence(woodType, true);
            ItemStack fireproofFenceGates = TreeManager.woodAccess.getFenceGate(woodType, true);
            ItemStack fireproofStairs = TreeManager.woodAccess.getStairs(woodType, true);
            planks.field_77994_a = 4;
            logs.field_77994_a = 1;
            RecipeUtil.addShapelessRecipe(planks.func_77946_l(), logs.func_77946_l());
            fireproofPlanks.field_77994_a = 4;
            fireproofLogs.field_77994_a = 1;
            RecipeUtil.addShapelessRecipe(fireproofPlanks.func_77946_l(), fireproofLogs.func_77946_l());
            slabs.field_77994_a = 6;
            planks.field_77994_a = 1;
            RecipeUtil.addPriorityRecipe(slabs.func_77946_l(), "###", Character.valueOf('#'), planks.func_77946_l());
            fireproofSlabs.field_77994_a = 6;
            fireproofPlanks.field_77994_a = 1;
            RecipeUtil.addPriorityRecipe(fireproofSlabs.func_77946_l(), "###", Character.valueOf('#'), fireproofPlanks.func_77946_l());
            fences.field_77994_a = 3;
            planks.field_77994_a = 1;
            RecipeUtil.addRecipe(fences.func_77946_l(), "#X#", "#X#", Character.valueOf('#'), planks.func_77946_l(), Character.valueOf('X'), "stickWood");
            fireproofFences.field_77994_a = 3;
            fireproofPlanks.field_77994_a = 1;
            RecipeUtil.addRecipe(fireproofFences.func_77946_l(), "#X#", "#X#", Character.valueOf('#'), fireproofPlanks.func_77946_l(), Character.valueOf('X'), "stickWood");
            fenceGates.field_77994_a = 1;
            planks.field_77994_a = 1;
            RecipeUtil.addRecipe(fenceGates.func_77946_l(), "X#X", "X#X", Character.valueOf('#'), planks.func_77946_l(), Character.valueOf('X'), "stickWood");
            fireproofFenceGates.field_77994_a = 1;
            fireproofPlanks.field_77994_a = 1;
            RecipeUtil.addRecipe(fireproofFenceGates.func_77946_l(), "X#X", "X#X", Character.valueOf('#'), fireproofPlanks.func_77946_l(), Character.valueOf('X'), "stickWood");
            stairs.field_77994_a = 4;
            planks.field_77994_a = 1;
            RecipeUtil.addPriorityRecipe(stairs.func_77946_l(), "#  ", "## ", "###", Character.valueOf('#'), planks.func_77946_l());
            fireproofStairs.field_77994_a = 4;
            fireproofPlanks.field_77994_a = 1;
            RecipeUtil.addPriorityRecipe(fireproofStairs.func_77946_l(), "#  ", "## ", "###", Character.valueOf('#'), fireproofPlanks.func_77946_l());
            doors.field_77994_a = 3;
            planks.field_77994_a = 1;
            RecipeUtil.addPriorityRecipe(doors.func_77946_l(), "## ", "## ", "## ", Character.valueOf('#'), planks.func_77946_l());
            doors.field_77994_a = 3;
            fireproofPlanks.field_77994_a = 1;
            RecipeUtil.addPriorityRecipe(doors.func_77946_l(), "## ", "## ", "## ", Character.valueOf('#'), fireproofPlanks.func_77946_l());
            if (!ForestryAPI.enabledPlugins.containsAll(Arrays.asList("forestry.factory", "forestry.apiculture"))) continue;
            logs.field_77994_a = 1;
            fireproofLogs.field_77994_a = 1;
            RecipeManagers.fabricatorManager.addRecipe(new FabricatorRecipe(null, Fluids.GLASS.getFluid(500), fireproofLogs.func_77946_l(), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), PluginCore.items.refractoryWax, Character.valueOf('X'), logs.func_77946_l()}));
            planks.field_77994_a = 1;
            fireproofPlanks.field_77994_a = 5;
            RecipeManagers.fabricatorManager.addRecipe(new FabricatorRecipe(null, Fluids.GLASS.getFluid(500), fireproofPlanks.func_77946_l(), new Object[]{"X#X", "#X#", "X#X", Character.valueOf('#'), PluginCore.items.refractoryWax, Character.valueOf('X'), planks.func_77946_l()}));
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.factory")) {
            int seedOilMultiplier = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
            int juiceMultiplier = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple");
            int mulchMultiplier = ForestryAPI.activeMode.getIntegerSetting("squeezer.mulch.apple");
            ItemStack mulch = new ItemStack((Item)PluginCore.items.mulch);
            RecipeManagers.squeezerManager.addRecipe(20, new ItemStack[]{ItemFruit.EnumFruit.CHERRY.getStack()}, Fluids.SEED_OIL.getFluid(5 * seedOilMultiplier), mulch, 5);
            RecipeManagers.squeezerManager.addRecipe(60, new ItemStack[]{ItemFruit.EnumFruit.WALNUT.getStack()}, Fluids.SEED_OIL.getFluid(18 * seedOilMultiplier), mulch, 5);
            RecipeManagers.squeezerManager.addRecipe(70, new ItemStack[]{ItemFruit.EnumFruit.CHESTNUT.getStack()}, Fluids.SEED_OIL.getFluid(22 * seedOilMultiplier), mulch, 2);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.LEMON.getStack()}, Fluids.JUICE.getFluid(juiceMultiplier * 2), mulch, (int)Math.floor((float)mulchMultiplier * 0.5f));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.PLUM.getStack()}, Fluids.JUICE.getFluid((int)Math.floor((float)juiceMultiplier * 0.5f)), mulch, mulchMultiplier * 3);
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.PAPAYA.getStack()}, Fluids.JUICE.getFluid(juiceMultiplier * 3), mulch, (int)Math.floor((float)mulchMultiplier * 0.5f));
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{ItemFruit.EnumFruit.DATES.getStack()}, Fluids.JUICE.getFluid((int)Math.floor((double)juiceMultiplier * 0.25)), mulch, mulchMultiplier);
            RecipeUtil.addFermenterRecipes(PluginArboriculture.items.sapling.getItemStack(), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        }
        RecipeUtil.addRecipe(PluginArboriculture.items.grafter.getItemStack(), "  B", " # ", "#  ", Character.valueOf('B'), "ingotBronze", Character.valueOf('#'), "stickWood");
        RecipeUtil.addRecipe(PluginArboriculture.blocks.treeChest, " # ", "XYX", "XXX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "treeSapling", Character.valueOf('Y'), "chestWood");
    }

    private static void createAlleles() {
        TreeBranchDefinition.createAlleles();
        AlleleGrowth.createAlleles();
        AlleleLeafEffect.createAlleles();
        AllelePlantType.createAlleles();
    }

    private static void registerErsatzGenomes() {
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.field_150362_t, 1, 0), TreeDefinition.Oak.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.field_150362_t, 1, 1), TreeDefinition.Spruce.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.field_150362_t, 1, 2), TreeDefinition.Birch.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.field_150362_t, 1, 3), TreeDefinition.Jungle.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.field_150361_u, 1, 0), TreeDefinition.AcaciaVanilla.getIndividual());
        AlleleManager.ersatzSpecimen.put(new ItemStack((Block)Blocks.field_150361_u, 1, 1), TreeDefinition.DarkOak.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.field_150345_g, 1, 0), TreeDefinition.Oak.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.field_150345_g, 1, 1), TreeDefinition.Spruce.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.field_150345_g, 1, 2), TreeDefinition.Birch.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.field_150345_g, 1, 3), TreeDefinition.Jungle.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.field_150345_g, 1, 4), TreeDefinition.AcaciaVanilla.getIndividual());
        AlleleManager.ersatzSaplings.put(new ItemStack(Blocks.field_150345_g, 1, 5), TreeDefinition.DarkOak.getIndividual());
    }

    @Override
    public IFuelHandler getFuelHandler() {
        return new FuelHandler();
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryArboriculture();
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-fence-block") && message.isStringMessage()) {
            Block block = ItemStackUtil.getBlockFromRegistry(message.getStringValue());
            if (block != null) {
                validFences.add(block);
            } else {
                IMCUtil.logInvalidIMCMessage(message);
            }
            return true;
        }
        return super.processIMCMessage(message);
    }

    @Override
    public void getHiddenItems(List<ItemStack> hiddenItems) {
        hiddenItems.add(new ItemStack((Block)PluginArboriculture.blocks.saplingGE));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(TextureStitchEvent.Pre event) {
        TextureLeaves.registerAllSprites();
        for (IAlleleFruit alleleFruit : AlleleFruit.getFruitAlleles()) {
            alleleFruit.getProvider().registerSprites();
        }
    }

    static {
        treekeepingMode = "NORMAL";
        validFences = new ArrayList<Block>();
    }

    private static class FuelHandler
    implements IFuelHandler {
        private FuelHandler() {
        }

        public int getBurnTime(ItemStack fuel) {
            Item item = fuel.func_77973_b();
            if (PluginArboriculture.items.sapling == item) {
                return 100;
            }
            Block block = Block.func_149634_a((Item)item);
            if (block instanceof IWoodTyped) {
                IWoodTyped woodTypedBlock = (IWoodTyped)block;
                if (woodTypedBlock.isFireproof()) {
                    return 0;
                }
                if (block instanceof BlockArbSlab) {
                    return 150;
                }
            }
            return 0;
        }
    }
}

