/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.arboriculture.ITree;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IPollinatable;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.BeeGenome;
import forestry.core.config.Config;
import forestry.core.errors.EnumErrorCode;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.GenericRatings;
import forestry.core.genetics.IndividualLiving;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.core.utils.VectUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class Bee
extends IndividualLiving
implements IBee {
    private int generation;
    private boolean isNatural = true;
    @Nonnull
    private final IBeeGenome genome;
    @Nullable
    private IBeeGenome mate;

    public Bee(@Nonnull NBTTagCompound nbt) {
        super(nbt);
        if (nbt.func_74764_b("NA")) {
            this.isNatural = nbt.func_74767_n("NA");
        }
        if (nbt.func_74764_b("GEN")) {
            this.generation = nbt.func_74762_e("GEN");
        }
        this.genome = nbt.func_74764_b("Genome") ? BeeGenome.fromNBT(nbt.func_74775_l("Genome")) : BeeDefinition.FOREST.getGenome();
        if (nbt.func_74764_b("Mate")) {
            this.mate = BeeGenome.fromNBT(nbt.func_74775_l("Mate"));
        }
    }

    public Bee(@Nonnull IBeeGenome genome, IBee mate) {
        this(genome);
        this.mate = mate.getGenome();
    }

    public Bee(@Nonnull IBeeGenome genome) {
        this(genome, true, 0);
    }

    private Bee(@Nonnull IBeeGenome genome, boolean isNatural, int generation) {
        super(genome.getLifespan());
        this.genome = genome;
        this.isNatural = isNatural;
        this.generation = generation;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (!this.isNatural) {
            nbttagcompound.func_74757_a("NA", false);
        }
        if (this.generation > 0) {
            nbttagcompound.func_74768_a("GEN", this.generation);
        }
    }

    @Override
    public void setIsNatural(boolean flag) {
        this.isNatural = flag;
    }

    @Override
    public boolean isNatural() {
        return this.isNatural;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public void mate(IIndividual individual) {
        if (!(individual instanceof IBee)) {
            return;
        }
        IBee drone = (IBee)individual;
        this.mate = drone.getGenome();
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, IBeeHousing housing) {
        IAlleleBeeEffect effect = this.genome.getEffect();
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doEffect(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = (IAlleleBeeEffect)this.genome.getInactiveAllele(EnumBeeChromosome.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], housing);
        return storedData;
    }

    private IEffectData doEffect(IAlleleBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.genome, storedData, housing);
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, IBeeHousing housing) {
        IAlleleBeeEffect effect = this.genome.getEffect();
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doFX(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = (IAlleleBeeEffect)this.genome.getInactiveAllele(EnumBeeChromosome.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doFX(secondary, storedData[1], housing);
        return storedData;
    }

    private IEffectData doFX(IAlleleBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        return effect.doFX(this.genome, storedData, housing);
    }

    @Override
    @Nonnull
    public IBeeGenome getGenome() {
        return this.genome;
    }

    @Override
    @Nullable
    public IBeeGenome getMate() {
        return this.mate;
    }

    @Override
    public IBee copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Bee(nbttagcompound);
    }

    @Override
    public boolean canSpawn() {
        return this.mate != null;
    }

    @Override
    public Set<IErrorState> getCanWork(IBeeHousing housing) {
        EnumTolerance beeToleranceHumidity;
        EnumHumidity beeBaseHumidity;
        EnumHumidity actualHumidity;
        EnumTolerance beeToleranceTemperature;
        EnumTemperature beeBaseTemperature;
        World world = housing.getWorldObj();
        BiomeGenBase biome = housing.getBiome();
        BlockPos housingCoords = housing.getCoordinates();
        HashSet<IErrorState> errorStates = new HashSet<IErrorState>();
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        if (world.func_175727_C(housingCoords.func_177982_a(0, 1, 0)) && !this.canFlyInRain(beeModifier)) {
            errorStates.add(EnumErrorCode.IS_RAINING);
        }
        if (world.func_72935_r()) {
            if (!this.canWorkDuringDay()) {
                errorStates.add(EnumErrorCode.NOT_NIGHT);
            }
        } else if (!this.canWorkAtNight(beeModifier)) {
            errorStates.add(EnumErrorCode.NOT_DAY);
        }
        if (housing.getBlockLightValue() > 11) {
            if (!this.canWorkDuringDay()) {
                errorStates.add(EnumErrorCode.NOT_GLOOMY);
            }
        } else if (!this.canWorkAtNight(beeModifier)) {
            errorStates.add(EnumErrorCode.NOT_BRIGHT);
        }
        if (!(biome == null || BiomeHelper.isBiomeHellish(biome) || housing.canBlockSeeTheSky() || this.canWorkUnderground(beeModifier))) {
            errorStates.add(EnumErrorCode.NO_SKY);
        }
        IAlleleBeeSpecies species = this.genome.getPrimary();
        EnumTemperature actualTemperature = housing.getTemperature();
        if (!AlleleManager.climateHelper.isWithinLimits(actualTemperature, beeBaseTemperature = species.getTemperature(), beeToleranceTemperature = this.genome.getToleranceTemp())) {
            if (beeBaseTemperature.ordinal() > actualTemperature.ordinal()) {
                errorStates.add(EnumErrorCode.TOO_COLD);
            } else {
                errorStates.add(EnumErrorCode.TOO_HOT);
            }
        }
        if (!AlleleManager.climateHelper.isWithinLimits(actualHumidity = housing.getHumidity(), beeBaseHumidity = species.getHumidity(), beeToleranceHumidity = this.genome.getToleranceHumid())) {
            if (beeBaseHumidity.ordinal() > actualHumidity.ordinal()) {
                errorStates.add(EnumErrorCode.TOO_ARID);
            } else {
                errorStates.add(EnumErrorCode.TOO_HUMID);
            }
        }
        return errorStates;
    }

    private boolean canWorkAtNight(IBeeModifier beeModifier) {
        return this.genome.getPrimary().isNocturnal() || this.genome.getNeverSleeps() || beeModifier.isSelfLighted();
    }

    private boolean canWorkDuringDay() {
        return !this.genome.getPrimary().isNocturnal() || this.genome.getNeverSleeps();
    }

    private boolean canWorkUnderground(IBeeModifier beeModifier) {
        return this.genome.getCaveDwelling() || beeModifier.isSunlightSimulated();
    }

    private boolean canFlyInRain(IBeeModifier beeModifier) {
        return this.genome.getToleratesRain() || beeModifier.isSealed();
    }

    private boolean isSuitableBiome(BiomeGenBase biome) {
        if (biome == null) {
            return false;
        }
        EnumTemperature temperature = EnumTemperature.getFromBiome(biome);
        EnumHumidity humidity = EnumHumidity.getFromValue(biome.func_76727_i());
        return this.isSuitableClimate(temperature, humidity);
    }

    private boolean isSuitableClimate(EnumTemperature temperature, EnumHumidity humidity) {
        return AlleleManager.climateHelper.isWithinLimits(temperature, humidity, this.genome.getPrimary().getTemperature(), this.genome.getToleranceTemp(), this.genome.getPrimary().getHumidity(), this.genome.getToleranceHumid());
    }

    public ArrayList<BiomeGenBase> getSuitableBiomes() {
        ArrayList<BiomeGenBase> suitableBiomes = new ArrayList<BiomeGenBase>();
        for (BiomeGenBase biome : BiomeGenBase.field_185377_q) {
            if (!this.isSuitableBiome(biome)) continue;
            suitableBiomes.add(biome);
        }
        return suitableBiomes;
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isAnalyzed) {
            list.add("<" + Translator.translateToLocal("for.gui.unknown") + ">");
            return;
        }
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        IAlleleBeeSpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumBeeChromosome.SPECIES)) {
            list.add(TextFormatting.BLUE + Translator.translateToLocal("for.bees.hybrid").replaceAll("%PRIMARY", primary.getName()).replaceAll("%SECONDARY", secondary.getName()));
        }
        if (this.generation > 0) {
            EnumRarity rarity = this.generation >= 1000 ? EnumRarity.EPIC : (this.generation >= 100 ? EnumRarity.RARE : (this.generation >= 10 ? EnumRarity.UNCOMMON : EnumRarity.COMMON));
            String generationString = rarity.field_77937_e + Translator.translateToLocalFormatted("for.gui.beealyzer.generations", this.generation);
            list.add(generationString);
        }
        IAllele speedAllele = this.genome.getActiveAllele(EnumBeeChromosome.SPEED);
        IAlleleTolerance tempToleranceAllele = (IAlleleTolerance)this.getGenome().getActiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE);
        IAlleleTolerance humidToleranceAllele = (IAlleleTolerance)this.getGenome().getActiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE);
        String unlocalizedCustomSpeed = "for.tooltip.worker." + speedAllele.getUnlocalizedName().replaceAll("(.*)\\.", "");
        String speed = Translator.canTranslateToLocal(unlocalizedCustomSpeed) ? Translator.translateToLocal(unlocalizedCustomSpeed) : speedAllele.getName() + ' ' + Translator.translateToLocal("for.gui.worker");
        String lifespan = this.genome.getActiveAllele(EnumBeeChromosome.LIFESPAN).getName() + ' ' + Translator.translateToLocal("for.gui.life");
        String tempTolerance = TextFormatting.GREEN + "T: " + AlleleManager.climateHelper.toDisplay(this.genome.getPrimary().getTemperature()) + " / " + tempToleranceAllele.getName();
        String humidTolerance = TextFormatting.GREEN + "H: " + AlleleManager.climateHelper.toDisplay(this.genome.getPrimary().getHumidity()) + " / " + humidToleranceAllele.getName();
        String flowers = this.genome.getFlowerProvider().getDescription();
        list.add(lifespan);
        list.add(speed);
        list.add(tempTolerance);
        list.add(humidTolerance);
        list.add(flowers);
        if (this.genome.getNeverSleeps()) {
            list.add(TextFormatting.RED + GenericRatings.rateActivityTime(this.genome.getNeverSleeps(), false));
        }
        if (this.genome.getToleratesRain()) {
            list.add(TextFormatting.WHITE + Translator.translateToLocal("for.gui.flyer.tooltip"));
        }
    }

    @Override
    public void age(World world, float housingLifespanModifier) {
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(world);
        IBeeModifier beeModifier = mode.getBeeModifier();
        float finalModifier = housingLifespanModifier * beeModifier.getLifespanModifier(this.genome, this.mate, housingLifespanModifier);
        super.age(world, finalModifier);
    }

    @Override
    public ItemStack[] getProduceList() {
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        IAlleleBeeSpecies secondary = this.genome.getSecondary();
        products.addAll(primary.getProductChances().keySet());
        Set<ItemStack> secondaryProducts = secondary.getProductChances().keySet();
        for (ItemStack second : secondaryProducts) {
            boolean skip = false;
            for (ItemStack compare : products) {
                if (!second.func_77969_a(compare)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            products.add(second);
        }
        return products.toArray(new ItemStack[products.size()]);
    }

    @Override
    public ItemStack[] getSpecialtyList() {
        Set<ItemStack> specialties = this.genome.getPrimary().getSpecialtyChances().keySet();
        return specialties.toArray(new ItemStack[specialties.size()]);
    }

    @Override
    public ItemStack[] produceStacks(IBeeHousing housing) {
        if (housing == null) {
            Log.warning("Failed to produce in an apiary because the beehousing was null.", new Object[0]);
            return null;
        }
        World world = housing.getWorldObj();
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(world);
        if (mode == null) {
            Log.warning("Failed to produce in an apiary because the beekeeping mode was null.", new Object[0]);
            return null;
        }
        ArrayList<ItemStack> products = new ArrayList<ItemStack>();
        IAlleleBeeSpecies primary = this.genome.getPrimary();
        IAlleleBeeSpecies secondary = this.genome.getSecondary();
        if (mode.isOverworked(this, housing)) {
            this.setIsNatural(false);
        }
        IBeeModifier beeHousingModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        IBeeModifier beeModeModifier = mode.getBeeModifier();
        float speed = this.genome.getSpeed() * beeHousingModifier.getProductionModifier(this.genome, 1.0f) * beeModeModifier.getProductionModifier(this.genome, 1.0f);
        for (Map.Entry<ItemStack, Float> entry : primary.getProductChances().entrySet()) {
            if (!(world.field_73012_v.nextFloat() < entry.getValue().floatValue() * speed)) continue;
            products.add(entry.getKey().func_77946_l());
        }
        for (Map.Entry<ItemStack, Float> entry : secondary.getProductChances().entrySet()) {
            if (!(world.field_73012_v.nextFloat() < (float)Math.round(entry.getValue().floatValue() / 2.0f) * speed)) continue;
            products.add(entry.getKey().func_77946_l());
        }
        if (primary.isJubilant(this.genome, housing) && secondary.isJubilant(this.genome, housing)) {
            for (Map.Entry<ItemStack, Float> entry : primary.getSpecialtyChances().entrySet()) {
                if (!(world.field_73012_v.nextFloat() < entry.getValue().floatValue() * speed)) continue;
                products.add(entry.getKey().func_77946_l());
            }
        }
        ItemStack[] productsArray = products.toArray(new ItemStack[products.size()]);
        BlockPos housingCoordinates = housing.getCoordinates();
        return this.genome.getFlowerProvider().affectProducts(world, this, housingCoordinates, productsArray);
    }

    @Override
    public IBee spawnPrincess(IBeeHousing housing) {
        if (this.mate == null) {
            return null;
        }
        if (BeeManager.beeRoot.getBeekeepingMode(housing.getWorldObj()).isFatigued(this, housing)) {
            return null;
        }
        return this.createOffspring(housing, this.getGeneration() + 1);
    }

    @Override
    public IBee[] spawnDrones(IBeeHousing housing) {
        World world = housing.getWorldObj();
        if (this.mate == null) {
            return null;
        }
        ArrayList<IBee> bees = new ArrayList<IBee>();
        BlockPos housingPos = housing.getCoordinates();
        int toCreate = BeeManager.beeRoot.getBeekeepingMode(world).getFinalFertility(this, world, housingPos);
        if (toCreate <= 0) {
            toCreate = 1;
        }
        for (int i = 0; i < toCreate; ++i) {
            IBee offspring = this.createOffspring(housing, 0);
            if (offspring == null) continue;
            offspring.setIsNatural(true);
            bees.add(offspring);
        }
        if (!bees.isEmpty()) {
            return bees.toArray(new IBee[bees.size()]);
        }
        return null;
    }

    private IBee createOffspring(IBeeHousing housing, int generation) {
        IChromosome[] mutated2;
        World world = housing.getWorldObj();
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated1 = Bee.mutateSpecies(housing, this.genome, this.mate);
        if (mutated1 != null) {
            parent1 = mutated1;
        }
        if ((mutated2 = Bee.mutateSpecies(housing, this.mate, this.genome)) != null) {
            parent2 = mutated2;
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome(world.field_73012_v, parent1[i], parent2[i]);
        }
        IBeekeepingMode mode = BeeManager.beeRoot.getBeekeepingMode(world);
        return new Bee(new BeeGenome(chromosomes), mode.isNaturalOffspring(this), generation);
    }

    private static IChromosome[] mutateSpecies(IBeeHousing housing, IBeeGenome genomeOne, IBeeGenome genomeTwo) {
        IBeeGenome genome1;
        IBeeGenome genome0;
        IAlleleBeeSpecies allele1;
        IAlleleBeeSpecies allele0;
        World world = housing.getWorldObj();
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            allele0 = (IAlleleBeeSpecies)parent1[EnumBeeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = (IAlleleBeeSpecies)parent2[EnumBeeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = (IAlleleBeeSpecies)parent2[EnumBeeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = (IAlleleBeeSpecies)parent1[EnumBeeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        GameProfile playerProfile = housing.getOwner();
        IApiaristTracker breedingTracker = BeeManager.beeRoot.getBreedingTracker(world, playerProfile);
        List<IMutation> combinations = BeeManager.beeRoot.getCombinations(allele0, allele1, true);
        for (IMutation mutation : combinations) {
            IBeeMutation beeMutation = (IBeeMutation)mutation;
            float chance = beeMutation.getChance(housing, allele0, allele1, genome0, genome1);
            if (chance <= 0.0f) continue;
            if (breedingTracker.isResearched(beeMutation)) {
                float mutationBoost = chance * (Config.researchMutationBoostMultiplier - 1.0f);
                mutationBoost = Math.min(Config.maxResearchMutationBoostPercent, mutationBoost);
                chance += mutationBoost;
            }
            if (!(chance > world.field_73012_v.nextFloat() * 100.0f)) continue;
            breedingTracker.registerMutation(mutation);
            return BeeManager.beeRoot.templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    @Override
    public ITree retrievePollen(IBeeHousing housing) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int chance = Math.round((float)this.genome.getFlowering() * beeModifier.getFloweringModifier(this.getGenome(), 1.0f));
        World world = housing.getWorldObj();
        Random random = world.field_73012_v;
        if (random.nextInt(100) >= chance) {
            return null;
        }
        Vec3i area = Bee.getArea(this.genome, beeModifier);
        Vec3i offset = new Vec3i(-area.func_177958_n() / 2, -area.func_177956_o() / 4, -area.func_177952_p() / 2);
        BlockPos housingPos = housing.getCoordinates();
        ITree pollen = null;
        for (int i = 0; i < 20; ++i) {
            BlockPos randomPos = VectUtil.getRandomPositionInArea(random, area);
            BlockPos blockPos = VectUtil.add(new Vec3i[]{housingPos, randomPos, offset});
            TileEntity tile = world.func_175625_s(blockPos);
            if (tile instanceof IPollinatable) {
                IPollinatable pitcher = (IPollinatable)tile;
                if (this.genome.getFlowerProvider().isAcceptedPollinatable(world, pitcher)) {
                    pollen = pitcher.getPollen();
                }
            } else {
                pollen = GeneticsUtil.getErsatzPollen(world, blockPos);
            }
            if (pollen == null) continue;
            return pollen;
        }
        return null;
    }

    @Override
    public boolean pollinateRandom(IBeeHousing housing, ITree pollen) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int chance = (int)((float)this.genome.getFlowering() * beeModifier.getFloweringModifier(this.getGenome(), 1.0f));
        World world = housing.getWorldObj();
        Random random = world.field_73012_v;
        if (random.nextInt(100) >= chance) {
            return false;
        }
        Vec3i area = Bee.getArea(this.genome, beeModifier);
        Vec3i offset = new Vec3i(-area.func_177958_n() / 2, -area.func_177956_o() / 4, -area.func_177952_p() / 2);
        BlockPos housingPos = housing.getCoordinates();
        for (int i = 0; i < 30; ++i) {
            IPollinatable realPollinatable;
            BlockPos randomPos = VectUtil.getRandomPositionInArea(random, area);
            BlockPos posBlock = VectUtil.add(new Vec3i[]{housingPos, randomPos, offset});
            ICheckPollinatable checkPollinatable = GeneticsUtil.getCheckPollinatable(world, posBlock);
            if (checkPollinatable == null || !this.genome.getFlowerProvider().isAcceptedPollinatable(world, checkPollinatable) || !checkPollinatable.canMateWith(pollen) || (realPollinatable = GeneticsUtil.getOrCreatePollinatable(housing.getOwner(), world, posBlock)) == null) continue;
            realPollinatable.mateWith(pollen);
            return true;
        }
        return false;
    }

    @Override
    public void plantFlowerRandom(IBeeHousing housing) {
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(housing);
        int chance = Math.round((float)this.genome.getFlowering() * beeModifier.getFloweringModifier(this.getGenome(), 1.0f));
        World world = housing.getWorldObj();
        Random random = world.field_73012_v;
        if (random.nextInt(100) >= chance) {
            return;
        }
        IFlowerProvider provider = this.genome.getFlowerProvider();
        Vec3i area = Bee.getArea(this.genome, beeModifier);
        Vec3i offset = new Vec3i(-area.func_177958_n() / 2, -area.func_177956_o() / 4, -area.func_177952_p() / 2);
        BlockPos housingPos = housing.getCoordinates();
        for (int i = 0; i < 10; ++i) {
            BlockPos randomPos = VectUtil.getRandomPositionInArea(random, area);
            BlockPos posBlock = VectUtil.add(new Vec3i[]{housingPos, randomPos, offset});
            if (FlowerManager.flowerRegistry.growFlower(provider.getFlowerType(), world, this, posBlock)) break;
        }
    }

    private static Vec3i getArea(IBeeGenome genome, IBeeModifier beeModifier) {
        Vec3i genomeTerritory = genome.getTerritory();
        float housingModifier = beeModifier.getTerritoryModifier(genome, 1.0f);
        return VectUtil.scale(genomeTerritory, housingModifier * 3.0f);
    }
}

