/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.ItemStackUtil;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableStacked
implements IFarmable {
    private final Block block;
    private final int matureHeight;
    private final int matureMeta;

    public FarmableStacked(Block block, int matureHeight, int matureMeta) {
        this.block = block;
        this.matureHeight = matureHeight;
        this.matureMeta = matureMeta;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this.block;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos) {
        BlockPos cropPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + this.matureHeight - 1, pos.func_177952_p());
        if (world.func_180495_p(cropPos).func_177230_c() != this.block) {
            return null;
        }
        return new CropBlock(world, this.block, this.matureMeta, cropPos);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStackUtil.equals(this.block, itemstack);
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        return world.func_180501_a(pos, this.block.func_176223_P(), 2);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

