/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.CreativeTabForestry;
import forestry.core.PluginCore;
import forestry.core.blocks.IBlockWithMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSoil
extends Block
implements IItemModelRegister,
IBlockWithMeta {
    private static final PropertyEnum<SoilType> SOIL = PropertyEnum.func_177709_a((String)"soil", SoilType.class);
    private static final int degradeDelimiter = 3;

    public BlockSoil() {
        super(Material.field_151578_c);
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149647_a(CreativeTabForestry.tabForestry);
    }

    public int func_176201_c(IBlockState state) {
        return ((SoilType)((Object)state.func_177229_b(SOIL))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SOIL, (Comparable)((Object)SoilType.values()[meta]));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SOIL});
    }

    public int func_149738_a(World world) {
        return 500;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        SoilType type = (SoilType)((Object)state.func_177229_b(SOIL));
        if (type == SoilType.PEAT) {
            ret.add(PluginCore.items.peat.getItemStack());
            ret.add(new ItemStack(Blocks.field_150346_d));
        } else if (type == SoilType.HUMUS) {
            ret.add(new ItemStack(Blocks.field_150346_d));
        } else {
            ret.add(new ItemStack((Block)this, 1, SoilType.BOG_EARTH.ordinal()));
        }
        return ret;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        SoilType type = (SoilType)((Object)state.func_177229_b(SOIL));
        if (type == SoilType.HUMUS) {
            BlockSoil.updateTickHumus(world, pos);
        } else if (type == SoilType.BOG_EARTH) {
            BlockSoil.updateTickBogEarth(world, pos);
        }
    }

    private static void updateTickHumus(World world, BlockPos pos) {
        if (BlockSoil.isEnrooted(world, pos)) {
            BlockSoil.degradeSoil(world, pos);
        }
    }

    private static void updateTickBogEarth(World world, BlockPos pos) {
        if (BlockSoil.isMoistened(world, pos)) {
            BlockSoil.matureBog(world, pos);
        }
    }

    private static boolean isEnrooted(World world, BlockPos pos) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos blockPos = pos.func_177982_a(i, 1, j);
                IBlockState state = world.func_180495_p(blockPos);
                Block block = state.func_177230_c();
                if (!(block instanceof BlockLog) && !(block instanceof IGrowable)) continue;
                return i != 0 || j != 0;
            }
        }
        return false;
    }

    private static void degradeSoil(World world, BlockPos pos) {
        if (world.field_73012_v.nextInt(140) != 0) {
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        int meta = block.func_176201_c(blockState);
        int type = meta & 3;
        int grade = meta >> 2;
        meta = ++grade << 2 | type;
        if (grade >= 3) {
            world.func_180501_a(pos, Blocks.field_150354_m.func_176223_P(), 2);
        } else {
            world.func_180501_a(pos, block.func_176203_a(meta), 2);
        }
        world.func_175704_b(pos, pos);
    }

    private static boolean isMoistened(World world, BlockPos pos) {
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                Block block = world.func_180495_p(new BlockPos(pos.func_177958_n() + i, pos.func_177956_o(), pos.func_177952_p() + j)).func_177230_c();
                if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) continue;
                return true;
            }
        }
        return false;
    }

    private static void matureBog(World world, BlockPos pos) {
        if (world.field_73012_v.nextInt(13) != 0) {
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        int meta = block.func_176201_c(blockState);
        int type = meta & 3;
        int maturity = meta >> 2;
        if (maturity >= 3) {
            return;
        }
        meta = ++maturity << 2 | type;
        world.func_180501_a(pos, block.func_176203_a(meta), 2);
        world.func_175704_b(pos, pos);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos);
        if (plantType != EnumPlantType.Crop && plantType != EnumPlantType.Plains) {
            return false;
        }
        SoilType type = (SoilType)((Object)world.func_180495_p(pos).func_177229_b(SOIL));
        return type == SoilType.HUMUS;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public static SoilType getTypeFromState(IBlockState state) {
        return (SoilType)((Object)state.func_177229_b(SOIL));
    }

    public static SoilType getTypeFromMeta(int meta) {
        int type = meta & 3;
        int maturity = meta >> 2;
        if (type == 1) {
            if (maturity < 3) {
                return SoilType.BOG_EARTH;
            }
            return SoilType.PEAT;
        }
        return SoilType.HUMUS;
    }

    public void func_149666_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        itemList.add(new ItemStack((Block)this, 1, 0));
        itemList.add(new ItemStack((Block)this, 1, 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0, "soil/humus");
        manager.registerItemModel(item, 1, "soil/bog");
        manager.registerItemModel(item, 2, "soil/peat");
    }

    @Override
    public String getNameFromMeta(int meta) {
        SoilType type = BlockSoil.getTypeFromMeta(meta);
        return type.func_176610_l();
    }

    public ItemStack get(SoilType soilType, int amount) {
        return new ItemStack((Block)this, amount, soilType.ordinal());
    }

    public static enum SoilType implements IStringSerializable
    {
        HUMUS("humus"),
        BOG_EARTH("bog_earth"),
        PEAT("peat");

        @Nonnull
        private final String name;

        private SoilType(String name) {
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }
    }
}

