/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.EnumWoodType;
import forestry.api.core.ForestryAPI;
import forestry.arboriculture.IWoodTyped;
import forestry.core.render.ForestryResource;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WoodHelper {
    @Nonnull
    public static String getDisplayName(IWoodTyped wood, EnumWoodType woodType) {
        String displayName;
        String blockKind = wood.getBlockKind();
        String customUnlocalizedName = "tile.for." + blockKind + "." + woodType.ordinal() + ".name";
        if (Translator.canTranslateToLocal(customUnlocalizedName)) {
            displayName = Translator.translateToLocal(customUnlocalizedName);
        } else {
            String woodGrammar = Translator.translateToLocal("for." + blockKind + ".grammar");
            String woodTypeName = Translator.translateToLocal("for.trees.woodType." + (Object)((Object)woodType));
            displayName = woodGrammar.replaceAll("%TYPE", woodTypeName);
        }
        if (wood.isFireproof()) {
            displayName = Translator.translateToLocalFormatted("tile.for.fireproof", displayName);
        }
        return displayName;
    }

    public static ResourceLocation[] getResourceLocations(IWoodTyped typed) {
        ArrayList<ForestryResource> resourceLocations = new ArrayList<ForestryResource>();
        String blockKind = typed.getBlockKind();
        for (EnumWoodType woodType : typed.getWoodTypes()) {
            resourceLocations.add(new ForestryResource(blockKind + "/" + (Object)((Object)woodType)));
        }
        return resourceLocations.toArray(new ResourceLocation[resourceLocations.size()]);
    }

    @SideOnly(value=Side.CLIENT)
    public static class WoodMeshDefinition
    implements ItemMeshDefinition {
        @Nonnull
        public IWoodTyped wood;

        public WoodMeshDefinition(@Nonnull IWoodTyped wood) {
            this.wood = wood;
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            int meta = stack.func_77960_j();
            EnumWoodType woodType = this.wood.getWoodType(meta);
            String blockKind = this.wood.getBlockKind();
            return ForestryAPI.modelManager.getModelLocation(blockKind + "/" + (Object)((Object)woodType));
        }
    }
}

