/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import forestry.api.mail.ILetter;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IStamps;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.Translator;
import forestry.mail.MailAddress;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.StringUtils;

public class Letter
implements ILetter {
    private static final Random rand = new Random();
    public static final short SLOT_ATTACHMENT_1 = 0;
    public static final short SLOT_ATTACHMENT_COUNT = 18;
    public static final short SLOT_POSTAGE_1 = 18;
    public static final short SLOT_POSTAGE_COUNT = 4;
    private boolean isProcessed = false;
    private IMailAddress sender;
    private IMailAddress[] recipient;
    private String text;
    private final InventoryAdapter inventory = new InventoryAdapter(22, "INV");
    private final String uid;

    public Letter(IMailAddress sender, IMailAddress recipient) {
        this.sender = sender;
        this.recipient = new IMailAddress[]{recipient};
        this.uid = String.valueOf(rand.nextInt());
    }

    public Letter(@Nonnull NBTTagCompound nbttagcompound) {
        this.isProcessed = nbttagcompound.func_74767_n("PRC");
        this.sender = new MailAddress(nbttagcompound.func_74775_l("SDR"));
        int recipientCount = nbttagcompound.func_74765_d("CRC");
        this.recipient = new MailAddress[recipientCount];
        for (int i = 0; i < recipientCount; ++i) {
            this.recipient[i] = new MailAddress(nbttagcompound.func_74775_l("RC" + i));
        }
        this.text = nbttagcompound.func_74779_i("TXT");
        this.uid = nbttagcompound.func_74779_i("UID");
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74757_a("PRC", this.isProcessed);
        NBTTagCompound subcompound = new NBTTagCompound();
        this.sender.writeToNBT(subcompound);
        nbttagcompound.func_74782_a("SDR", (NBTBase)subcompound);
        nbttagcompound.func_74777_a("CRC", (short)this.recipient.length);
        for (int i = 0; i < this.recipient.length; ++i) {
            subcompound = new NBTTagCompound();
            this.recipient[i].writeToNBT(subcompound);
            nbttagcompound.func_74782_a("RC" + i, (NBTBase)subcompound);
        }
        nbttagcompound.func_74778_a("TXT", this.text);
        nbttagcompound.func_74778_a("UID", this.uid);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public ItemStack[] getPostage() {
        return InventoryUtil.getStacks((IInventory)this.inventory, 18, 4);
    }

    @Override
    public ItemStack[] getAttachments() {
        return InventoryUtil.getStacks((IInventory)this.inventory, 0, 18);
    }

    @Override
    public int countAttachments() {
        int count = 0;
        for (ItemStack stack : this.getAttachments()) {
            if (stack == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void addAttachment(ItemStack itemstack) {
        InventoryUtil.tryAddStack((IInventory)this.inventory, itemstack, false);
    }

    @Override
    public void addAttachments(ItemStack[] itemstacks) {
        for (ItemStack stack : itemstacks) {
            this.addAttachment(stack);
        }
    }

    @Override
    public void invalidatePostage() {
        for (int i = 18; i < 22; ++i) {
            this.inventory.func_70299_a(i, null);
        }
    }

    @Override
    public void setProcessed(boolean flag) {
        this.isProcessed = flag;
    }

    @Override
    public boolean isProcessed() {
        return this.isProcessed;
    }

    @Override
    public boolean isMailable() {
        return !this.isProcessed && this.recipient != null && this.recipient.length > 0;
    }

    @Override
    public boolean isPostPaid() {
        int posted = 0;
        for (ItemStack stamp : this.getPostage()) {
            if (stamp == null || !(stamp.func_77973_b() instanceof IStamps)) continue;
            posted += ((IStamps)stamp.func_77973_b()).getPostage(stamp).getValue() * stamp.field_77994_a;
        }
        return posted >= this.requiredPostage();
    }

    @Override
    public int requiredPostage() {
        int required = 1;
        for (ItemStack attach : this.getAttachments()) {
            if (attach == null) continue;
            ++required;
        }
        return required;
    }

    @Override
    public void addStamps(ItemStack stamps) {
        InventoryUtil.tryAddStack((IInventory)this.inventory, stamps, 18, 4, false);
    }

    @Override
    public boolean hasRecipient() {
        if (this.getRecipients().length <= 0) {
            return false;
        }
        IMailAddress recipient = this.getRecipients()[0];
        if (recipient == null) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)recipient.getName());
    }

    @Override
    public void setSender(IMailAddress address) {
        this.sender = address;
    }

    @Override
    public IMailAddress getSender() {
        return this.sender;
    }

    @Override
    public void setRecipient(IMailAddress address) {
        this.recipient = address == null ? new IMailAddress[0] : new IMailAddress[]{address};
    }

    @Override
    public IMailAddress[] getRecipients() {
        return this.recipient;
    }

    @Override
    public String getRecipientString() {
        StringBuilder recipientString = new StringBuilder();
        for (IMailAddress address : this.recipient) {
            if (recipientString.length() > 0) {
                recipientString.append(", ");
            }
            recipientString.append(address.getName());
        }
        return recipientString.toString();
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void addTooltip(List<String> list) {
        if (this.sender != null && StringUtils.isNotBlank((CharSequence)this.sender.getName())) {
            list.add(Translator.translateToLocal("for.gui.mail.from") + ": " + this.sender.getName());
        }
        if (this.recipient != null && this.recipient.length > 0) {
            list.add(Translator.translateToLocal("for.gui.mail.to") + ": " + this.getRecipientString());
        }
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int var1) {
        return this.inventory.func_70301_a(var1);
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return this.inventory.func_70298_a(var1, var2);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.inventory.func_70299_a(var1, var2);
    }

    public String func_70005_c_() {
        return this.inventory.func_70005_c_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70296_d() {
        this.inventory.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_174889_b(EntityPlayer var1) {
        this.inventory.func_174889_b(var1);
    }

    public void func_174886_c(EntityPlayer var1) {
        this.inventory.func_174886_c(var1);
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.inventory.func_94041_b(i, itemstack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public ITextComponent func_145748_c_() {
        return this.inventory.func_145748_c_();
    }
}

