/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableCocoa
implements IFarmable {
    private static final Block COCOA_PLANT = Blocks.field_150375_by;
    public static final Item COCOA_SEED = Items.field_151100_aR;
    public static final int COCOA_META = 3;

    @Override
    public boolean isSaplingAt(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == COCOA_PLANT;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block != COCOA_PLANT) {
            return null;
        }
        int meta = block.func_176201_c(blockState);
        if ((Integer)blockState.func_177229_b((IProperty)BlockCocoa.field_176501_a) < 2) {
            return null;
        }
        return new CropBlock(world, block, meta, pos);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return itemstack.func_77973_b() == COCOA_SEED && itemstack.func_77952_i() == 3;
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        return BlockUtil.tryPlantCocoaPod(world, pos);
    }
}

