/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.ItemStackUtil;
import forestry.farming.logic.FarmLogic;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FarmLogicSucculent
extends FarmLogic {
    private final IFarmable[] germlings;

    public FarmLogicSucculent(IFarmHousing housing) {
        super(housing);
        Collection<IFarmable> farmables = Farmables.farmables.get("farmSucculentes");
        this.germlings = farmables.toArray(new IFarmable[farmables.size()]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Item getItem() {
        return Items.field_151100_aR;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getMetadata() {
        return 2;
    }

    @Override
    public String getName() {
        if (this.isManual) {
            return "Manual Succulent Farm";
        }
        return "Managed Succulent Farm";
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return 1;
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        if (this.isManual) {
            return false;
        }
        return ItemStackUtil.equals((Block)Blocks.field_150354_m, itemstack);
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        if (this.isManual) {
            return false;
        }
        return ItemStackUtil.equals((Block)Blocks.field_150434_aF, itemstack);
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        return null;
    }

    @Override
    public boolean cultivate(BlockPos pos, FarmDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(BlockPos pos, FarmDirection direction, int extent) {
        World world = this.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, i);
            for (IFarmable seed : this.germlings) {
                ICrop crop = seed.getCropAt(world, position);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

