/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicHomogeneous;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FarmLogicEnder
extends FarmLogicHomogeneous {
    public FarmLogicEnder(IFarmHousing housing) {
        super(housing, new ItemStack(Blocks.field_150377_bs), new ItemStack(Blocks.field_150377_bs), (Iterable<IFarmable>)Farmables.farmables.get("farmEnder"));
    }

    @Override
    public String getName() {
        return "Managed Ender Farm";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Item getItem() {
        return Items.field_151061_bv;
    }

    @Override
    public int getFertilizerConsumption() {
        return 20;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return 0;
    }

    @Override
    public Collection<ItemStack> collect() {
        return null;
    }

    @Override
    public Collection<ICrop> harvest(BlockPos pos, FarmDirection direction, int extent) {
        World world = this.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, i);
            for (IFarmable farmable : this.germlings) {
                ICrop crop = farmable.getCropAt(world, position);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }

    @Override
    protected boolean maintainGermlings(BlockPos pos, FarmDirection direction, int extent) {
        World world = this.getWorld();
        for (int i = 0; i < extent; ++i) {
            BlockPos soilPos;
            IBlockState blockState;
            Block block;
            ItemStack below;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            IBlockState state = world.func_180495_p(position);
            if (!world.func_175623_d(position) && !BlockUtil.isReplaceableBlock(state, world, position) || !this.isAcceptedSoil(below = (block = (blockState = world.func_180495_p(soilPos = position.func_177977_b())).func_177230_c()).getPickBlock(blockState, null, world, soilPos, null))) continue;
            return this.trySetCrop(position);
        }
        return false;
    }

    private boolean trySetCrop(BlockPos position) {
        World world = this.getWorld();
        for (IFarmable candidate : this.germlings) {
            if (!this.housing.plantGermling(candidate, world, position)) continue;
            return true;
        }
        return false;
    }
}

