/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.farming.logic.FarmLogicWatered;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class FarmLogicCrops
extends FarmLogicWatered {
    private static final ItemStack farmland = new ItemStack(Blocks.field_150458_ak, 1, Short.MAX_VALUE);
    private final Iterable<IFarmable> seeds;

    protected FarmLogicCrops(IFarmHousing housing, Iterable<IFarmable> seeds) {
        super(housing, new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150458_ak));
        this.seeds = seeds;
    }

    @Override
    public boolean isAcceptedGround(ItemStack itemStack) {
        return super.isAcceptedGround(itemStack) || ItemStackUtil.isIdenticalItem(farmland, itemStack);
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack itemstack) {
        for (IFarmable germling : this.seeds) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        List products = this.produce;
        this.produce = this.collectEntityItems(false);
        return products;
    }

    @Override
    protected boolean maintainCrops(BlockPos pos, FarmDirection direction, int extent) {
        World world = this.getWorld();
        for (int i = 0; i < extent; ++i) {
            BlockPos position = this.translateWithOffset(pos, direction, i);
            IBlockState state = world.func_180495_p(position);
            if (!world.func_175623_d(position) && !BlockUtil.isReplaceableBlock(state, world, position)) continue;
            BlockPos soilPosition = position.func_177977_b();
            IBlockState blockState = world.func_180495_p(soilPosition);
            Block block = blockState.func_177230_c();
            ItemStack below = block.getPickBlock(blockState, null, world, soilPosition, null);
            if (this.ground.func_77973_b() != below.func_77973_b() || below.func_77952_i() <= 0) continue;
            return this.trySetCrop(position);
        }
        return false;
    }

    private boolean trySetCrop(BlockPos position) {
        World world = this.getWorld();
        for (IFarmable candidate : this.seeds) {
            if (!this.housing.plantGermling(candidate, world, position)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ICrop> harvest(BlockPos pos, FarmDirection direction, int extent) {
        World world = this.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            BlockPos position = this.translateWithOffset(pos.func_177982_a(0, 1, 0), direction, i);
            for (IFarmable seed : this.seeds) {
                ICrop crop = seed.getCropAt(world, position);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

