/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.Farmables;
import forestry.api.farming.IFarmable;
import forestry.core.PluginCore;
import forestry.core.circuits.Circuit;
import forestry.core.circuits.CircuitLayout;
import forestry.core.items.EnumElectronTube;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.IMCUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.farming.blocks.BlockRegistryFarming;
import forestry.farming.blocks.EnumFarmBlockType;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.logic.FarmLogicArboreal;
import forestry.farming.logic.FarmLogicCereal;
import forestry.farming.logic.FarmLogicCocoa;
import forestry.farming.logic.FarmLogicGourd;
import forestry.farming.logic.FarmLogicInfernal;
import forestry.farming.logic.FarmLogicOrchard;
import forestry.farming.logic.FarmLogicPeat;
import forestry.farming.logic.FarmLogicReeds;
import forestry.farming.logic.FarmLogicShroom;
import forestry.farming.logic.FarmLogicSucculent;
import forestry.farming.logic.FarmLogicVegetable;
import forestry.farming.logic.FarmableBasicFruit;
import forestry.farming.logic.FarmableGE;
import forestry.farming.logic.FarmableGenericCrop;
import forestry.farming.logic.FarmableGenericSapling;
import forestry.farming.logic.FarmableGourd;
import forestry.farming.logic.FarmableStacked;
import forestry.farming.logic.FarmableVanillaMushroom;
import forestry.farming.logic.FarmableVanillaSapling;
import forestry.farming.models.EnumFarmBlockTexture;
import forestry.farming.proxy.ProxyFarming;
import forestry.farming.tiles.TileFarmControl;
import forestry.farming.tiles.TileFarmGearbox;
import forestry.farming.tiles.TileFarmHatch;
import forestry.farming.tiles.TileFarmPlain;
import forestry.farming.tiles.TileFarmValve;
import forestry.farming.triggers.FarmingTriggers;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ForestryPlugin(pluginID="forestry.farming", name="Farming", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.farming.description")
public class PluginFarming
extends BlankForestryPlugin {
    @SidedProxy(clientSide="forestry.farming.proxy.ProxyFarmingClient", serverSide="forestry.farming.proxy.ProxyFarming")
    public static ProxyFarming proxy;
    public static int modelIdFarmBlock;
    public static BlockRegistryFarming blocks;

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistryFarming();
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Farmables.farmables.put("farmArboreal", new ArrayList());
        Farmables.farmables.get("farmArboreal").add(new FarmableVanillaSapling());
        if (ForestryAPI.enabledPlugins.contains("forestry.arboriculture")) {
            Farmables.farmables.get("farmArboreal").add(new FarmableGE());
        }
        Farmables.farmables.put("farmOrchard", new ArrayList());
        Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(Blocks.field_150464_aj, 7));
        Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(Blocks.field_150469_bN, 7));
        Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(Blocks.field_150459_bM, 7));
        Farmables.farmables.put("farmShroom", new ArrayList());
        Farmables.farmables.get("farmShroom").add(new FarmableVanillaMushroom((Block)Blocks.field_150338_P, 0));
        Farmables.farmables.get("farmShroom").add(new FarmableVanillaMushroom((Block)Blocks.field_150337_Q, 0));
        Farmables.farmables.put("farmWheat", new ArrayList());
        Farmables.farmables.get("farmWheat").add(new FarmableGenericCrop(new ItemStack(Items.field_151014_N), Blocks.field_150464_aj, 7, new ItemStack[0]));
        Farmables.farmables.put("farmGourd", new ArrayList());
        Farmables.farmables.get("farmGourd").add(new FarmableGourd(new ItemStack(Items.field_151080_bb), new ItemStack(Blocks.field_150393_bb), new ItemStack(Blocks.field_150423_aK)));
        Farmables.farmables.get("farmGourd").add(new FarmableGourd(new ItemStack(Items.field_151081_bc), new ItemStack(Blocks.field_150394_bc), new ItemStack(Blocks.field_150440_ba)));
        Farmables.farmables.put("farmInfernal", new ArrayList());
        Farmables.farmables.get("farmInfernal").add(new FarmableGenericCrop(new ItemStack(Items.field_151075_bm), Blocks.field_150388_bm, 3, new ItemStack[0]));
        Farmables.farmables.put("farmPoales", new ArrayList());
        Farmables.farmables.get("farmPoales").add(new FarmableStacked((Block)Blocks.field_150436_aH, 3, 0));
        Farmables.farmables.put("farmSucculentes", new ArrayList());
        Farmables.farmables.get("farmSucculentes").add(new FarmableStacked((Block)Blocks.field_150434_aF, 3, 0));
        Farmables.farmables.put("farmVegetables", new ArrayList());
        Farmables.farmables.get("farmVegetables").add(new FarmableGenericCrop(new ItemStack(Items.field_151174_bG), Blocks.field_150469_bN, 7, new ItemStack[0]));
        Farmables.farmables.get("farmVegetables").add(new FarmableGenericCrop(new ItemStack(Items.field_151172_bF), Blocks.field_150459_bM, 7, new ItemStack[0]));
        proxy.initializeModels();
        CircuitLayout layoutManaged = new CircuitLayout("farms.managed", CircuitSocketType.FARM);
        ChipsetManager.circuitRegistry.registerLayout(layoutManaged);
        CircuitLayout layoutManual = new CircuitLayout("farms.manual", CircuitSocketType.FARM);
        ChipsetManager.circuitRegistry.registerLayout(layoutManual);
    }

    @Override
    public void registerTriggers() {
        FarmingTriggers.initialize();
    }

    @Override
    public void doInit() {
        super.doInit();
        GameRegistry.registerTileEntity(TileFarmPlain.class, (String)"forestry.Farm");
        GameRegistry.registerTileEntity(TileFarmGearbox.class, (String)"forestry.FarmGearbox");
        GameRegistry.registerTileEntity(TileFarmHatch.class, (String)"forestry.FarmHatch");
        GameRegistry.registerTileEntity(TileFarmValve.class, (String)"forestry.FarmValve");
        GameRegistry.registerTileEntity(TileFarmControl.class, (String)"forestry.FarmControl");
        Circuit.farmArborealManaged = new CircuitFarmLogic("managedArboreal", FarmLogicArboreal.class);
        Circuit.farmShroomManaged = new CircuitFarmLogic("managedShroom", FarmLogicShroom.class);
        Circuit.farmPeatManaged = new CircuitFarmLogic("managedPeat", FarmLogicPeat.class);
        Circuit.farmCerealManaged = new CircuitFarmLogic("managedCereal", FarmLogicCereal.class);
        Circuit.farmVegetableManaged = new CircuitFarmLogic("managedVegetable", FarmLogicVegetable.class);
        Circuit.farmInfernalManaged = new CircuitFarmLogic("managedInfernal", FarmLogicInfernal.class);
        Circuit.farmPeatManual = new CircuitFarmLogic("manualPeat", FarmLogicPeat.class).setManual();
        Circuit.farmShroomManual = new CircuitFarmLogic("manualShroom", FarmLogicShroom.class).setManual();
        Circuit.farmCerealManual = new CircuitFarmLogic("manualCereal", FarmLogicCereal.class).setManual();
        Circuit.farmVegetableManual = new CircuitFarmLogic("manualVegetable", FarmLogicVegetable.class).setManual();
        Circuit.farmSucculentManual = new CircuitFarmLogic("manualSucculent", FarmLogicSucculent.class).setManual();
        Circuit.farmPoalesManual = new CircuitFarmLogic("manualPoales", FarmLogicReeds.class).setManual();
        Circuit.farmGourdManual = new CircuitFarmLogic("manualGourd", FarmLogicGourd.class).setManual();
        Circuit.farmCocoaManual = new CircuitFarmLogic("manualCocoa", FarmLogicCocoa.class).setManual();
        Circuit.farmOrchardManual = new CircuitFarmLogic("manualOrchard", FarmLogicOrchard.class);
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-farmable-sapling")) {
            String[] tokens = message.getStringValue().split("@");
            String errormsg = IMCUtil.getInvalidIMCMessageText(message);
            if (tokens.length != 2) {
                Log.warning(errormsg, new Object[0]);
                return true;
            }
            if (!Farmables.farmables.containsKey(tokens[0])) {
                Log.warning("%s For non-existent farm %s.", errormsg, tokens[0]);
                return true;
            }
            Collection<IFarmable> farmables = Farmables.farmables.get(tokens[0]);
            String itemString = tokens[1];
            Matcher matcher = Pattern.compile("(.+?)\\.(-?[0-9][0-9]?)(?:\\.(.+?)\\.(-?[0-9][0-9]?))?").matcher(itemString);
            if (!matcher.matches()) {
                Log.warning("%s For farm '%s': unable to parse string.", errormsg, tokens[0]);
                return true;
            }
            MatchResult matchResult = matcher.toMatchResult();
            String saplingString = matchResult.group(1);
            String saplingMetaString = matchResult.group(2);
            String windfallString = matchResult.group(3);
            String windfallMetaString = matchResult.group(4);
            try {
                Block sapling = ItemStackUtil.getBlockFromRegistry(saplingString);
                if (sapling == null) {
                    throw new IllegalArgumentException("can't find block for " + saplingString);
                }
                int saplingMeta = Integer.parseInt(saplingMetaString);
                if (windfallString == null) {
                    farmables.add(new FarmableGenericSapling(sapling, saplingMeta, new ItemStack[0]));
                } else {
                    Item windfall = ItemStackUtil.getItemFromRegistry(windfallString);
                    if (windfall == null) {
                        throw new IllegalArgumentException("can't find item for " + windfallString);
                    }
                    ItemStack windfallStack = new ItemStack(windfall, 1, Integer.parseInt(windfallMetaString));
                    farmables.add(new FarmableGenericSapling(sapling, saplingMeta, windfallStack));
                }
            }
            catch (IllegalArgumentException e) {
                Log.warning("%s for farm '%s'", errormsg, tokens[0], e.getMessage());
            }
            return true;
        }
        if (message.key.equals("add-farmable-crop")) {
            String[] tokens = message.getStringValue().split("@");
            String errormsg = IMCUtil.getInvalidIMCMessageText(message);
            if (tokens.length != 2) {
                Log.warning(errormsg, new Object[0]);
                return true;
            }
            if (!Farmables.farmables.containsKey(tokens[0])) {
                Log.warning("%s For non-existent farm %s.", errormsg, tokens[0]);
                return true;
            }
            String[] items = tokens[1].split("[\\.]+");
            if (items.length != 4) {
                Log.warning("%s For farm '%s': id definitions did not match.", errormsg, tokens[0]);
                return true;
            }
            try {
                Item seed = ItemStackUtil.getItemFromRegistry(items[0]);
                if (seed == null) {
                    throw new IllegalArgumentException("can't find item for " + items[0]);
                }
                Block crop = ItemStackUtil.getBlockFromRegistry(items[2]);
                if (crop == null) {
                    throw new IllegalArgumentException("can't find block for " + items[2]);
                }
                Farmables.farmables.get(tokens[0]).add(new FarmableGenericCrop(new ItemStack(seed, 1, Integer.parseInt(items[1])), crop, Integer.parseInt(items[3]), new ItemStack[0]));
            }
            catch (IllegalArgumentException e) {
                Log.warning("%s for farm '%s': %s", errormsg, tokens[0], e.getMessage());
            }
            return true;
        }
        return false;
    }

    @Override
    public void registerRecipes() {
        ItemStack basic = PluginFarming.blocks.farm.get(EnumFarmBlockType.PLAIN, 1);
        ItemStack gearbox = PluginFarming.blocks.farm.get(EnumFarmBlockType.GEARBOX, 1);
        ItemStack hatch = PluginFarming.blocks.farm.get(EnumFarmBlockType.HATCH, 1);
        ItemStack valve = PluginFarming.blocks.farm.get(EnumFarmBlockType.VALVE, 1);
        ItemStack control = PluginFarming.blocks.farm.get(EnumFarmBlockType.CONTROL, 1);
        for (EnumFarmBlockTexture block : EnumFarmBlockTexture.values()) {
            NBTTagCompound compound = new NBTTagCompound();
            block.saveToCompound(compound);
            basic.func_77982_d(compound);
            gearbox.func_77982_d(compound);
            hatch.func_77982_d(compound);
            valve.func_77982_d(compound);
            control.func_77982_d(compound);
            RecipeUtil.addRecipe(basic, "I#I", "WCW", Character.valueOf('#'), block.getBase(), Character.valueOf('W'), "slabWood", Character.valueOf('C'), PluginCore.items.tubes.get(EnumElectronTube.TIN, 1), Character.valueOf('I'), "ingotCopper");
            RecipeUtil.addRecipe(gearbox, " # ", "TTT", Character.valueOf('#'), basic, Character.valueOf('T'), "gearTin");
            RecipeUtil.addRecipe(hatch, " # ", "TDT", Character.valueOf('#'), basic, Character.valueOf('T'), "gearTin", Character.valueOf('D'), Blocks.field_150415_aT);
            RecipeUtil.addRecipe(valve, " # ", "XTX", Character.valueOf('#'), basic, Character.valueOf('T'), "gearTin", Character.valueOf('X'), "blockGlass");
            RecipeUtil.addRecipe(control, " # ", "XTX", Character.valueOf('#'), basic, Character.valueOf('T'), PluginCore.items.tubes.get(EnumElectronTube.GOLD, 1), Character.valueOf('X'), "dustRedstone");
        }
        ICircuitLayout layoutManaged = ChipsetManager.circuitRegistry.getLayout("forestry.farms.managed");
        ICircuitLayout layoutManual = ChipsetManager.circuitRegistry.getLayout("forestry.farms.manual");
        ChipsetManager.solderManager.addRecipe(layoutManaged, PluginCore.items.tubes.get(EnumElectronTube.COPPER, 1), Circuit.farmArborealManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, PluginCore.items.tubes.get(EnumElectronTube.TIN, 1), Circuit.farmPeatManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, PluginCore.items.tubes.get(EnumElectronTube.BRONZE, 1), Circuit.farmCerealManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, PluginCore.items.tubes.get(EnumElectronTube.IRON, 1), Circuit.farmVegetableManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, PluginCore.items.tubes.get(EnumElectronTube.BLAZE, 1), Circuit.farmInfernalManaged);
        ChipsetManager.solderManager.addRecipe(layoutManaged, PluginCore.items.tubes.get(EnumElectronTube.APATITE, 1), Circuit.farmShroomManaged);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.COPPER, 1), Circuit.farmOrchardManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.TIN, 1), Circuit.farmPeatManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.BRONZE, 1), Circuit.farmCerealManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.IRON, 1), Circuit.farmVegetableManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.GOLD, 1), Circuit.farmSucculentManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.DIAMOND, 1), Circuit.farmPoalesManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.OBSIDIAN, 1), Circuit.farmGourdManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.APATITE, 1), Circuit.farmShroomManual);
        ChipsetManager.solderManager.addRecipe(layoutManual, PluginCore.items.tubes.get(EnumElectronTube.LAPIS, 1), Circuit.farmCocoaManual);
    }

    @Override
    public void getHiddenItems(List<ItemStack> hiddenItems) {
        hiddenItems.add(new ItemStack((Block)PluginFarming.blocks.mushroom, 1, Short.MAX_VALUE));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleTextureRemap(TextureStitchEvent.Pre event) {
        EnumFarmBlockType.registerSprites();
    }
}

