/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IArmorNaturalist;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IPollinatable;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.arboriculture.genetics.pollination.CheckPollinatableTree;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.utils.ItemStackUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneticsUtil {
    private static Set<Block> ersatzSpecimenBlocks;

    private static Set<Block> getErsatzBlocks() {
        if (ersatzSpecimenBlocks == null) {
            ersatzSpecimenBlocks = new HashSet<Block>();
            for (ItemStack ersatzSpecimen : AlleleManager.ersatzSpecimen.keySet()) {
                Block ersatzBlock = ItemStackUtil.getBlock(ersatzSpecimen);
                if (ersatzBlock == null) continue;
                ersatzSpecimenBlocks.add(ersatzBlock);
            }
        }
        return ersatzSpecimenBlocks;
    }

    private static boolean isErsatzBlock(Block block) {
        return block != null && GeneticsUtil.getErsatzBlocks().contains(block);
    }

    public static boolean hasNaturalistEye(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        ItemStack armorItemStack = player.field_71071_by.field_70460_b[3];
        if (armorItemStack == null) {
            return false;
        }
        Item armorItem = armorItemStack.func_77973_b();
        if (!(armorItem instanceof IArmorNaturalist)) {
            return false;
        }
        IArmorNaturalist armorNaturalist = (IArmorNaturalist)armorItem;
        return armorNaturalist.canSeePollination(player, armorItemStack, true);
    }

    public static boolean canNurse(IButterfly butterfly, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IButterflyNursery) {
            return ((IButterflyNursery)tile).canNurse(butterfly);
        }
        return GeneticsUtil.getErsatzPollen(world, pos) != null;
    }

    public static ICheckPollinatable getCheckPollinatable(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IPollinatable) {
            return (IPollinatable)tile;
        }
        ITree pollen = GeneticsUtil.getErsatzPollen(world, pos);
        if (pollen != null) {
            return new CheckPollinatableTree(pollen);
        }
        return null;
    }

    public static IPollinatable getOrCreatePollinatable(GameProfile owner, World world, BlockPos pos) {
        ITree pollen;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IPollinatable) {
            return (IPollinatable)tile;
        }
        if (Config.pollinateVanillaTrees && (pollen = GeneticsUtil.getErsatzPollen(world, pos)) != null) {
            pollen.setLeaves(world, owner, pos);
            return (IPollinatable)world.func_175625_s(pos);
        }
        return null;
    }

    public static ITree getErsatzPollen(World world, BlockPos pos) {
        ItemStack itemStack;
        IIndividual tree;
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!GeneticsUtil.isErsatzBlock(block)) {
            return null;
        }
        int meta = block.func_176201_c(blockState);
        if (Blocks.field_150362_t == block || Blocks.field_150361_u == block) {
            if ((meta & 4) != 0) {
                return null;
            }
            if (block == Blocks.field_150361_u) {
                meta += 4;
            }
            block = Blocks.field_150345_g;
        }
        if ((tree = GeneticsUtil.getGeneticEquivalent(itemStack = new ItemStack(block, 1, meta))) instanceof ITree) {
            return (ITree)tree;
        }
        return null;
    }

    public static IIndividual getGeneticEquivalent(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof ItemGE) {
            return ((ItemGE)item).getIndividual(itemStack);
        }
        for (Map.Entry<ItemStack, IIndividual> entry : AlleleManager.ersatzSaplings.entrySet()) {
            if (!ItemStackUtil.isIdenticalItem(itemStack, entry.getKey())) continue;
            return entry.getValue().copy();
        }
        return null;
    }

    public static ItemStack convertSaplingToGeneticEquivalent(ItemStack foreign) {
        if (foreign == null) {
            return null;
        }
        IIndividual tree = GeneticsUtil.getGeneticEquivalent(foreign);
        if (!(tree instanceof ITree)) {
            return null;
        }
        ItemStack ersatz = TreeManager.treeRoot.getMemberStack(tree, EnumGermlingType.SAPLING);
        ersatz.field_77994_a = foreign.field_77994_a;
        return ersatz;
    }

    public static int getResearchComplexity(IAlleleSpecies species, IChromosomeType speciesChromosome) {
        return 1 + GeneticsUtil.getGeneticAdvancement(species, new HashSet<IAlleleSpecies>(), speciesChromosome);
    }

    private static int getGeneticAdvancement(IAlleleSpecies species, Set<IAlleleSpecies> exclude, IChromosomeType speciesChromosome) {
        int highest = 0;
        exclude.add(species);
        for (IMutation iMutation : species.getRoot().getPaths(species, speciesChromosome)) {
            highest = GeneticsUtil.getHighestAdvancement(iMutation.getAllele0(), highest, exclude, speciesChromosome);
            highest = GeneticsUtil.getHighestAdvancement(iMutation.getAllele1(), highest, exclude, speciesChromosome);
        }
        return 1 + highest;
    }

    private static int getHighestAdvancement(IAlleleSpecies mutationSpecies, int highest, Set<IAlleleSpecies> exclude, IChromosomeType speciesChromosome) {
        if (exclude.contains(mutationSpecies) || AlleleManager.alleleRegistry.isBlacklisted(mutationSpecies.getUID())) {
            return highest;
        }
        int otherAdvance = GeneticsUtil.getGeneticAdvancement(mutationSpecies, exclude, speciesChromosome);
        return otherAdvance > highest ? otherAdvance : highest;
    }
}

