/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.tiles;

import forestry.api.core.INbtWritable;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.tiles.EscritoireGame;
import forestry.core.tiles.EscritoireGameToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class EscritoireGameBoard
implements INbtWritable,
IStreamable {
    private static final Random rand = new Random();
    private static final int TOKEN_COUNT_MAX = 22;
    private static final int TOKEN_COUNT_MIN = 6;
    private final List<EscritoireGameToken> gameTokens = new ArrayList<EscritoireGameToken>(22);
    private int tokenCount;

    public EscritoireGameBoard() {
    }

    public EscritoireGameBoard(@Nonnull NBTTagCompound nbt) {
        this.tokenCount = nbt.func_74762_e("TokenCount");
        if (this.tokenCount > 0) {
            EscritoireGameToken[] tokens = new EscritoireGameToken[this.tokenCount];
            NBTTagList nbttaglist = nbt.func_150295_c("GameTokens", 10);
            for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
                NBTTagCompound nbttagcompound2 = nbttaglist.func_150305_b(j);
                byte index = nbttagcompound2.func_74771_c("Slot");
                tokens[index] = new EscritoireGameToken(nbttagcompound2);
            }
            Collections.addAll(this.gameTokens, tokens);
        }
    }

    public boolean initialize(ItemStack specimen) {
        IIndividual individual = AlleleManager.alleleRegistry.getIndividual(specimen);
        if (individual == null) {
            return false;
        }
        IGenome genome = individual.getGenome();
        ISpeciesRoot root = genome.getPrimary().getRoot();
        this.tokenCount = EscritoireGameBoard.getTokenCount(genome);
        for (int i = 0; i < this.tokenCount / 2; ++i) {
            IIndividual token = root.templateAsIndividual(root.getRandomTemplate(rand));
            ItemStack pair = root.getMemberStack(token, root.getIconType());
            this.gameTokens.add(new EscritoireGameToken(pair));
            this.gameTokens.add(new EscritoireGameToken(pair));
        }
        Collections.shuffle(this.gameTokens);
        return true;
    }

    public EscritoireGameToken getToken(int index) {
        if (index >= this.tokenCount) {
            return null;
        }
        return this.gameTokens.get(index);
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public void hideProbedTokens() {
        for (EscritoireGameToken token : this.gameTokens) {
            if (!token.isProbed()) continue;
            token.setProbed(false);
        }
    }

    private List<EscritoireGameToken> getUnrevealedTokens() {
        ArrayList<EscritoireGameToken> unrevealed = new ArrayList<EscritoireGameToken>();
        for (EscritoireGameToken token : this.gameTokens) {
            if (token.isVisible()) continue;
            unrevealed.add(token);
        }
        return unrevealed;
    }

    private EscritoireGameToken getSelected() {
        for (EscritoireGameToken token : this.gameTokens) {
            if (!token.isSelected()) continue;
            return token;
        }
        return null;
    }

    private boolean isBoardCleared() {
        for (EscritoireGameToken token : this.gameTokens) {
            if (token.isMatched()) continue;
            return false;
        }
        return true;
    }

    public void probe() {
        List<EscritoireGameToken> tokens = this.getUnrevealedTokens();
        int index = rand.nextInt(tokens.size());
        EscritoireGameToken token = tokens.get(index);
        token.setProbed(true);
    }

    public EscritoireGame.Status choose(EscritoireGameToken token) {
        EscritoireGame.Status status = EscritoireGame.Status.PLAYING;
        if (token.isMatched() || token.isSelected()) {
            return status;
        }
        EscritoireGameToken selected = this.getSelected();
        if (selected == null) {
            token.setSelected();
            this.hideProbedTokens();
        } else if (token.matches(selected)) {
            selected.setMatched();
            token.setMatched();
            if (this.isBoardCleared()) {
                status = EscritoireGame.Status.SUCCESS;
            }
            this.hideProbedTokens();
        } else {
            token.setFailed();
            selected.setFailed();
            status = EscritoireGame.Status.FAILURE;
        }
        return status;
    }

    public void reset() {
        this.gameTokens.clear();
        this.tokenCount = 0;
    }

    private static int getTokenCount(IGenome genome) {
        IAlleleSpecies species1 = genome.getPrimary();
        IAlleleSpecies species2 = genome.getSecondary();
        int tokenCount = species1.getComplexity() + species2.getComplexity();
        if (tokenCount % 2 != 0) {
            tokenCount = Math.round((float)tokenCount / 2.0f) * 2;
        }
        if (tokenCount > 22) {
            tokenCount = 22;
        } else if (tokenCount < 6) {
            tokenCount = 6;
        }
        return tokenCount;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.tokenCount > 0) {
            nbttagcompound.func_74768_a("TokenCount", this.tokenCount);
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < this.tokenCount; ++i) {
                EscritoireGameToken token = this.gameTokens.get(i);
                if (token == null) continue;
                NBTTagCompound nbttagcompound2 = new NBTTagCompound();
                nbttagcompound2.func_74774_a("Slot", (byte)i);
                token.writeToNBT(nbttagcompound2);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound2);
            }
            nbttagcompound.func_74782_a("GameTokens", (NBTBase)nbttaglist);
        } else {
            nbttagcompound.func_74768_a("TokenCount", 0);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.tokenCount);
        data.writeStreamables(this.gameTokens);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        this.tokenCount = data.readVarInt();
        data.readStreamables(this.gameTokens, EscritoireGameToken.class);
    }
}

