/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.proxy;

import forestry.core.TickHandlerCoreClient;
import forestry.core.models.ModelManager;
import forestry.core.multiblock.MultiblockClientTickHandler;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.proxy.ProxyCommon;
import forestry.core.render.TextureManager;
import forestry.core.worldgen.WorldGenerator;
import java.io.File;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.input.Keyboard;

public class ProxyCommonClient
extends ProxyCommon {
    @Override
    public void registerTickHandlers(WorldGenerator worldGenerator) {
        super.registerTickHandlers(worldGenerator);
        MinecraftForge.EVENT_BUS.register((Object)new TickHandlerCoreClient());
        MinecraftForge.EVENT_BUS.register((Object)new MultiblockClientTickHandler());
    }

    @Override
    public void registerBlock(Block block) {
        ModelManager.getInstance().registerBlockClient(block);
        TextureManager.getInstance().registerBlock(block);
    }

    @Override
    public void registerItem(Item item) {
        ModelManager.getInstance().registerItemClient(item);
        TextureManager.getInstance().registerItem(item);
    }

    @Override
    public File getForestryRoot() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @Override
    public World getRenderWorld() {
        return this.getClientInstance().field_71441_e;
    }

    @Override
    public boolean isOp(EntityPlayer player) {
        return false;
    }

    @Override
    public double getBlockReachDistance(EntityPlayer entityplayer) {
        if (entityplayer instanceof EntityPlayerSP) {
            return this.getClientInstance().field_71442_b.func_78757_d();
        }
        return 4.0;
    }

    @Override
    public boolean isShiftDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @Override
    public String getDisplayName(ItemStack itemstack) {
        return itemstack.func_77973_b().func_77653_i(itemstack);
    }

    @Override
    public void playBlockBreakSoundFX(World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        this.playSoundFX(world, pos, block.func_185467_w().func_185845_c(), SoundCategory.BLOCKS, block.func_185467_w().func_185843_a() / 4.0f, block.func_185467_w().func_185847_b());
    }

    @Override
    public void playBlockPlaceSoundFX(World world, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        this.playSoundFX(world, pos, block.func_185467_w().func_185844_d(), SoundCategory.BLOCKS, block.func_185467_w().func_185843_a() / 4.0f, block.func_185467_w().func_185847_b());
    }

    @Override
    public void sendFXSignal(PacketFXSignal.VisualFXType visualFX, PacketFXSignal.SoundFXType soundFX, World world, BlockPos pos, IBlockState state) {
    }

    @Override
    public void playSoundFX(World world, BlockPos pos, SoundEvent sound, SoundCategory soundCategory, float volume, float pitch) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        world.func_184134_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, sound, soundCategory, volume, pitch, false);
    }

    @Override
    public void addBlockDestroyEffects(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            this.getClientInstance().field_71452_i.func_180533_a(pos, state);
        } else {
            super.addBlockDestroyEffects(world, pos, state);
        }
    }

    @Override
    public void addBlockPlaceEffects(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            this.playBlockPlaceSoundFX(world, pos, state);
        } else {
            super.addBlockPlaceEffects(world, pos, state);
        }
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

