/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.api.core.INbtWritable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class PipetteContents
implements INbtWritable {
    @Nonnull
    private final FluidStack contents;

    @Nullable
    public static PipetteContents create(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        NBTTagCompound nbt = itemStack.func_77978_p();
        FluidStack contents = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        if (contents == null) {
            return null;
        }
        return new PipetteContents(contents);
    }

    public PipetteContents(@Nonnull FluidStack contents) {
        this.contents = contents;
    }

    @Nonnull
    public FluidStack getContents() {
        return this.contents;
    }

    public boolean isFull() {
        return this.contents.amount >= 1000;
    }

    public void addTooltip(List<String> list) {
        String descr = this.contents.getFluid().getLocalizedName(this.contents);
        descr = descr + " (" + this.contents.amount + " mb)";
        list.add(descr);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        this.contents.writeToNBT(nbttagcompound);
    }
}

