/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.EnumLeafType;
import forestry.core.render.TextureManager;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class TextureLeaves {
    private static final Map<EnumLeafType, TextureLeaves> leafTextures = new EnumMap<EnumLeafType, TextureLeaves>(EnumLeafType.class);
    private final EnumLeafType leafType;
    private TextureAtlasSprite plain;
    private TextureAtlasSprite pollinated;
    private TextureAtlasSprite fancy;

    public static TextureLeaves get(EnumLeafType leafType) {
        return leafTextures.get((Object)leafType);
    }

    public static void registerAllSprites() {
        for (TextureLeaves leafTexture : leafTextures.values()) {
            leafTexture.registerSprites();
        }
    }

    private TextureLeaves(EnumLeafType enumLeafType) {
        this.leafType = enumLeafType;
    }

    private void registerSprites() {
        String ident = this.leafType.toString().toLowerCase(Locale.ENGLISH);
        this.plain = TextureManager.registerSprite("blocks/leaves/" + ident + ".plain");
        this.pollinated = TextureManager.registerSprite("blocks/leaves/" + ident + ".changed");
        this.fancy = TextureManager.registerSprite("blocks/leaves/" + ident + ".fancy");
    }

    public TextureAtlasSprite getPlain() {
        return this.plain;
    }

    public TextureAtlasSprite getPollinated() {
        return this.pollinated;
    }

    public TextureAtlasSprite getFancy() {
        return this.fancy;
    }

    static {
        for (EnumLeafType leafType : EnumLeafType.values()) {
            leafTextures.put(leafType, new TextureLeaves(leafType));
        }
    }
}

