/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.models;

import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.core.IModelBaker;
import forestry.arboriculture.blocks.BlockForestryLeaves;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeRoot;
import forestry.arboriculture.items.ItemBlockLeaves;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.models.ModelBlockDefault;
import forestry.core.proxy.Proxies;
import forestry.core.tiles.TileUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;

public class ModelLeaves
extends ModelBlockDefault<BlockForestryLeaves> {
    public ModelLeaves() {
        super(BlockForestryLeaves.class);
    }

    @Override
    public void bakeInventoryBlock(@Nonnull BlockForestryLeaves block, @Nonnull ItemStack itemStack, @Nonnull IModelBaker baker) {
        if (!(itemStack.func_77973_b() instanceof ItemBlockLeaves) || block == null) {
            return;
        }
        TileLeaves leaves = new TileLeaves();
        if (itemStack.func_77942_o()) {
            leaves.func_145839_a(itemStack.func_77978_p());
        } else {
            leaves.setTree(TreeRoot.treeTemplates.get(0));
        }
        TextureAtlasSprite leavesIcon = leaves.getLeaveSprite(Proxies.render.fancyGraphicsEnabled());
        if (leavesIcon == null) {
            return;
        }
        baker.addBlockModel((Block)block, Block.field_185505_j, null, leavesIcon, 0);
        if (!leaves.hasFruit()) {
            return;
        }
        TextureAtlasSprite fruitTexture = leaves.getFruitSprite();
        if (fruitTexture == null) {
            return;
        }
        baker.addBlockModel((Block)block, Block.field_185505_j, null, fruitTexture, 1);
    }

    @Override
    public void bakeWorldBlock(@Nonnull BlockForestryLeaves block, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IExtendedBlockState stateExtended, @Nonnull IModelBaker baker) {
        TileLeaves tile = TileUtil.getTile(world, pos, TileLeaves.class);
        if (tile == null) {
            IAlleleTreeSpecies oakSpecies = TreeDefinition.Oak.getIndividual().getGenome().getPrimary();
            baker.setParticleSprite(oakSpecies.getLeafSpriteProvider().getSprite(false, Proxies.render.fancyGraphicsEnabled()));
            return;
        }
        TextureAtlasSprite leaveSprite = tile.getLeaveSprite(Proxies.render.fancyGraphicsEnabled());
        baker.addBlockModel((Block)block, Block.field_185505_j, pos, leaveSprite, 0);
        TextureAtlasSprite fruitSprite = tile.getFruitSprite();
        if (fruitSprite != null) {
            baker.addBlockModel((Block)block, Block.field_185505_j, pos, fruitSprite, 1);
        }
        baker.setParticleSprite(leaveSprite);
    }
}

