/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlyzer;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesType;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyMutation;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.api.lepidopterology.ILepidopteristTracker;
import forestry.core.genetics.SpeciesRoot;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.EntityUtil;
import forestry.lepidopterology.PluginLepidopterology;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyGenome;
import forestry.lepidopterology.genetics.Flutterlyzer;
import forestry.lepidopterology.genetics.LepidopteristTracker;
import forestry.lepidopterology.genetics.MothDefinition;
import forestry.lepidopterology.items.ItemButterflyGE;
import forestry.lepidopterology.tiles.TileCocoon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class ButterflyRoot
extends SpeciesRoot
implements IButterflyRoot {
    private static int butterflySpeciesCount = -1;
    public static final String UID = "rootButterflies";
    private static final ArrayList<IButterfly> butterflyTemplates = new ArrayList();
    private static final ArrayList<IButterflyMutation> butterflyMutations = new ArrayList();

    @Override
    public String getUID() {
        return UID;
    }

    @Override
    public Class<? extends IIndividual> getMemberClass() {
        return IButterfly.class;
    }

    @Override
    public int getSpeciesCount() {
        if (butterflySpeciesCount < 0) {
            butterflySpeciesCount = 0;
            for (Map.Entry<String, IAllele> entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                if (!(entry.getValue() instanceof IAlleleButterflySpecies) || !((IAlleleButterflySpecies)entry.getValue()).isCounted()) continue;
                ++butterflySpeciesCount;
            }
        }
        return butterflySpeciesCount;
    }

    @Override
    public boolean isMember(ItemStack stack) {
        return this.getType(stack) != null;
    }

    @Override
    @Nullable
    public EnumFlutterType getType(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (PluginLepidopterology.items.butterflyGE == item) {
            return EnumFlutterType.BUTTERFLY;
        }
        if (PluginLepidopterology.items.serumGE == item) {
            return EnumFlutterType.SERUM;
        }
        if (PluginLepidopterology.items.caterpillarGE == item) {
            return EnumFlutterType.CATERPILLAR;
        }
        if (PluginLepidopterology.items.cocoonGE == item) {
            return EnumFlutterType.COCOON;
        }
        return null;
    }

    @Override
    public EnumFlutterType getIconType() {
        return EnumFlutterType.BUTTERFLY;
    }

    @Override
    public boolean isMember(ItemStack stack, ISpeciesType type) {
        return this.getType(stack) == type;
    }

    @Override
    public boolean isMember(IIndividual individual) {
        return individual instanceof IButterfly;
    }

    @Override
    public IButterfly getMember(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        if (!this.isMember(stack)) {
            return null;
        }
        return new Butterfly(stack.func_77978_p());
    }

    @Override
    public IButterfly getMember(NBTTagCompound compound) {
        return new Butterfly(compound);
    }

    @Override
    public ItemStack getMemberStack(IIndividual butterfly, ISpeciesType type) {
        ItemButterflyGE butterflyItem;
        if (!(type instanceof EnumFlutterType)) {
            return null;
        }
        switch ((EnumFlutterType)type) {
            case SERUM: {
                butterflyItem = PluginLepidopterology.items.serumGE;
                break;
            }
            case CATERPILLAR: {
                butterflyItem = PluginLepidopterology.items.caterpillarGE;
                break;
            }
            case COCOON: {
                butterflyItem = PluginLepidopterology.items.cocoonGE;
                break;
            }
            default: {
                butterflyItem = PluginLepidopterology.items.butterflyGE;
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        butterfly.writeToNBT(nbttagcompound);
        ItemStack stack = new ItemStack((Item)butterflyItem);
        stack.func_77982_d(nbttagcompound);
        return stack;
    }

    public EntityButterfly spawnButterflyInWorld(World world, IButterfly butterfly, double x, double y, double z) {
        return EntityUtil.spawnEntity(world, new EntityButterfly(world, butterfly), x, y, z);
    }

    @Override
    public boolean plantCocoon(World world, IButterflyNursery nursery, GameProfile owner, int age) {
        IBlockState state;
        BlockPos pos = this.getNextPos(world, nursery.getCoordinates());
        boolean placed = world.func_180501_a(pos, state = PluginLepidopterology.blocks.cocoon.func_176223_P(), 3);
        if (!placed) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (PluginLepidopterology.blocks.cocoon != block) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileCocoon)) {
            world.func_175698_g(pos);
            return false;
        }
        TileCocoon cocoon = (TileCocoon)tile;
        cocoon.setCaterpillar(nursery.getCaterpillar());
        cocoon.setOwner(owner);
        cocoon.setNursery(nursery);
        cocoon.setAge(age);
        return true;
    }

    private BlockPos getNextPos(World world, BlockPos pos) {
        IBlockState blockState;
        do {
            pos.func_177977_b();
        } while (!BlockUtil.canReplace(blockState = world.func_180495_p(pos), world, pos));
        return pos;
    }

    @Override
    public boolean isMated(ItemStack stack) {
        IButterfly butterfly = this.getMember(stack);
        if (butterfly == null) {
            return false;
        }
        return butterfly.getMate() != null;
    }

    @Override
    public IButterfly templateAsIndividual(IAllele[] template) {
        return new Butterfly(this.templateAsGenome(template));
    }

    @Override
    public IButterfly templateAsIndividual(IAllele[] templateActive, IAllele[] templateInactive) {
        return new Butterfly(this.templateAsGenome(templateActive, templateInactive));
    }

    @Override
    public IButterflyGenome templateAsGenome(IAllele[] template) {
        return new ButterflyGenome(this.templateAsChromosomes(template));
    }

    @Override
    public IButterflyGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new ButterflyGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }

    @Override
    public ArrayList<IButterfly> getIndividualTemplates() {
        return butterflyTemplates;
    }

    @Override
    public IAllele[] getDefaultTemplate() {
        return MothDefinition.Brimstone.getTemplate();
    }

    @Override
    public void registerTemplate(String identifier, IAllele[] template) {
        butterflyTemplates.add(ButterflyManager.butterflyRoot.templateAsIndividual(template));
        this.speciesTemplates.put(identifier, template);
    }

    @Override
    public void registerMutation(IMutation mutation) {
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getTemplate()[0].getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele0().getUID())) {
            return;
        }
        if (AlleleManager.alleleRegistry.isBlacklisted(mutation.getAllele1().getUID())) {
            return;
        }
        butterflyMutations.add((IButterflyMutation)mutation);
    }

    @Override
    public Collection<IButterflyMutation> getMutations(boolean shuffle) {
        if (shuffle) {
            Collections.shuffle(butterflyMutations);
        }
        return butterflyMutations;
    }

    @Override
    public ILepidopteristTracker getBreedingTracker(World world, GameProfile player) {
        String filename = "LepidopteristTracker." + (player == null ? "common" : player.getId());
        LepidopteristTracker tracker = (LepidopteristTracker)world.func_72943_a(LepidopteristTracker.class, filename);
        if (tracker == null) {
            tracker = new LepidopteristTracker(filename);
            world.func_72823_a(filename, (WorldSavedData)tracker);
        }
        tracker.setUsername(player);
        tracker.setWorld(world);
        return tracker;
    }

    @Override
    public IChromosomeType[] getKaryotype() {
        return EnumButterflyChromosome.values();
    }

    @Override
    public IChromosomeType getKaryotypeKey() {
        return EnumButterflyChromosome.SPECIES;
    }

    @Override
    public IAlyzer getAlyzer() {
        return new Flutterlyzer();
    }
}

