/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableGenericCrop
implements IFarmable {
    private final ItemStack seed;
    private final Block block;
    private final int mature;
    private final ItemStack[] windfall;

    public FarmableGenericCrop(ItemStack seed, Block block, int mature, ItemStack ... windfall) {
        this.seed = seed;
        this.block = block;
        this.mature = mature;
        this.windfall = windfall;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this.block;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block != this.block) {
            return null;
        }
        if (block.func_176201_c(blockState) != this.mature) {
            return null;
        }
        return new CropBlock(world, this.block, this.mature, pos);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        if (this.seed.func_77973_b() != itemstack.func_77973_b()) {
            return false;
        }
        if (this.seed.func_77952_i() >= 0) {
            return this.seed.func_77952_i() == itemstack.func_77952_i();
        }
        return true;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        return germling.func_77946_l().func_179546_a(player, world, pos.func_177977_b(), EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f) == EnumActionResult.SUCCESS;
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        for (ItemStack drop : this.windfall) {
            if (!drop.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }
}

